set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8106369';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4034',
      '34303423',
      64.854367,
      24,
      '0102121',
      4,
      1,
      0.210961,
      3,
      '332122',
      5.011029,
      ' 6-19-1992',
      38.126594,
      22.752789,
      1,
      NULL,
      3,
      0.829072,
      1,
      0,
      NULL,
      3.906525,
      3.913401,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      NULL,
      5.561483,
      1,
      2,
      1,
      1.998992,
      NULL,
      1,
      1,
      1.320405,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.281464,
      1,
      3,
      0.726942,
      1,
      2.594785,
      1,
      1.359184,
      1,
      0.528683,
      1.174647,
      0.935961,
      2,
      0.158882,
      0.269734,
      NULL,
      0.145955,
      NULL,
      0,
      NULL,
      NULL,
      5,
      1,
      0,
      1.728248,
      0,
      NULL,
      NULL,
      0.479435,
      NULL,
      NULL,
      0,
      NULL,
      3.008138,
      0,
      NULL,
      0,
      0,
      0.673184,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1.342857,
      1,
      1.257514,
      1,
      1.438393,
      NULL,
      0.436198,
      3,
      1.198675,
      1.010797,
      NULL,
      1.791152,
      1,
      0,
      5,
      1.833316,
      1,
      1.113554,
      NULL,
      4,
      1,
      NULL,
      6.833507,
      NULL,
      3.609391,
      8.267083,
      NULL,
      6,
      0,
      NULL,
      NULL,
      4,
      5.716869,
      1,
      0.495055,
      0.921505,
      2.914924,
      2,
      1.275962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.454269,
      1,
      0,
      1,
      0.004645,
      NULL,
      0.234215,
      0.084385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.661404,
      NULL,
      4.687314,
      3,
      2.541534,
      0.594771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.954672,
      1.454688,
      2,
      3.541546,
      2,
      0.902865,
      2,
      2.153643,
      2,
      5,
      1,
      1,
      1.338384,
      NULL,
      NULL,
      NULL,
      NULL,
      6.592704,
      1.264766,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.278237,
      2.795971,
      0.389683,
      1.698143,
      NULL,
      2,
      0.605957,
      1,
      0.351308,
      1.346266,
      1,
      1,
      NULL,
      1,
      0,
      0,
      0,
      0.892917,
      1,
      1.254488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.415867,
      NULL,
      NULL,
      NULL,
      NULL,
      1.191596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.576334,
      NULL,
      NULL,
      '',
      0.591029,
      '',
      '',
      '',
      3,
      NULL,
      '',
      '',
      2.012225,
      3.882094,
      3.958002,
      1.298420,
      NULL,
      1,
      NULL,
      0,
      NULL);
commit;
end;
/


