set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8106369';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0114',
      NULL,
      33.101403,
      83.781541,
      '3012233',
      11.960046,
      6,
      NULL,
      3,
      '102341',
      1,
      ' 8- 6-1990',
      41.118054,
      53,
      0.624951,
      NULL,
      2,
      NULL,
      1.302565,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      5,
      0.737979,
      0,
      1,
      1,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      1.982440,
      NULL,
      1,
      1,
      0.291259,
      0.682437,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      2.273122,
      NULL,
      0,
      0,
      0.008862,
      1.019444,
      NULL,
      3,
      0,
      1,
      0.382087,
      NULL,
      1.887046,
      2,
      1.148488,
      0,
      1,
      0.106350,
      1.314750,
      1,
      7.968729,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.927660,
      1,
      1,
      NULL,
      1.917609,
      0,
      0,
      1,
      1.857772,
      0.604289,
      1.246346,
      NULL,
      0.954011,
      0.502888,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.176667,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.667654,
      1.031758,
      5,
      0,
      7.288532,
      5.191291,
      NULL,
      2.528080,
      8,
      2.735834,
      2.147994,
      2,
      8.959502,
      4.806678,
      NULL,
      3.707206,
      2.597877,
      1,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.644886,
      0,
      NULL,
      NULL,
      1.521624,
      1.086170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.399878,
      NULL,
      5,
      NULL,
      2.940616,
      0.512159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.993177,
      1,
      NULL,
      NULL,
      NULL,
      0.023449,
      1.725654,
      6,
      1,
      1,
      1,
      1.104747,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.786474,
      1.541766,
      1,
      0,
      3.862663,
      0,
      NULL,
      NULL,
      1.026762,
      1,
      NULL,
      0.968393,
      1.493163,
      0,
      1.661109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      '24242',
      '',
      NULL,
      '',
      '',
      '',
      0.452295,
      '',
      '',
      '',
      3,
      3.102339,
      NULL,
      5,
      0.968828,
      2.100935,
      NULL,
      3.216318,
      1.343197);
commit;
end;
/


