set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502280';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      15.029694,
      NULL,
      '1404434',
      10,
      NULL,
      3,
      2,
      '430332',
      0,
      ' 9-16-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.299819,
      1,
      1,
      1,
      1.074487,
      NULL,
      3.537368,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      0.533278,
      0,
      0.914759,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.176203,
      0.151926,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.078652,
      0.977719,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.641725,
      2,
      9,
      4.094093,
      6.317875,
      0,
      NULL,
      0.092174,
      0.179286,
      0.682062,
      NULL,
      NULL,
      1,
      0.516790,
      1,
      1,
      0.000597,
      1,
      NULL,
      NULL,
      0.814544,
      3.973277,
      2,
      6.335073,
      0,
      NULL,
      NULL,
      0.490154,
      0,
      0.245805,
      0,
      0.272830,
      0,
      1,
      0,
      6,
      0,
      0.039466,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      4,
      0,
      7,
      1,
      5.381402,
      NULL,
      NULL,
      0.051925,
      1,
      0.175112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.193284,
      0.158399,
      1,
      0,
      1.455432,
      0.939251,
      1,
      1.109634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      1,
      3.558296,
      0.560865,
      0.723185,
      4,
      6.993983,
      2.475899,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.576159,
      3,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.012912,
      6.524314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.164921,
      0.720121,
      2.889495,
      3,
      0.159882,
      1,
      1.964799,
      NULL,
      1.662310,
      NULL,
      1.916215,
      0.455618,
      0,
      1.313614,
      1.958208,
      1,
      1.238644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.742494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.209698,
      NULL,
      '14422',
      '',
      NULL,
      '',
      '',
      '',
      1.149134,
      '02414',
      '',
      '',
      4.361189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


