set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502280';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '11243433',
      34,
      57.673995,
      '4324312',
      NULL,
      3,
      3.747913,
      3,
      '010020',
      6.001744,
      '11-10-1985',
      25.313239,
      20,
      1,
      NULL,
      0.196685,
      1,
      NULL,
      1,
      NULL,
      1.882646,
      1.760395,
      1.855168,
      1.510535,
      0.757362,
      5.693066,
      0,
      0,
      1.542753,
      1.789472,
      0,
      2.255754,
      1,
      1.728889,
      1,
      1,
      0.784718,
      4,
      0,
      1,
      0.308144,
      0.334203,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.392452,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.855059,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.569531,
      NULL,
      3,
      2.929081,
      2,
      NULL,
      0.713918,
      1,
      1.809950,
      0.983796,
      1.799017,
      NULL,
      1.000220,
      0,
      0,
      1,
      NULL,
      0.049734,
      1.570124,
      NULL,
      NULL,
      5,
      1,
      0,
      0,
      0.159771,
      5,
      0,
      1.608330,
      1.088792,
      0,
      0.008776,
      0,
      0,
      NULL,
      NULL,
      4.152305,
      4.904378,
      NULL,
      NULL,
      1,
      NULL,
      4.667700,
      1,
      1,
      1.624044,
      NULL,
      5,
      2.571690,
      1.057632,
      1.713512,
      3.116987,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.705313,
      0,
      1,
      0,
      1,
      5.682712,
      5,
      0.971723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.333991,
      NULL,
      NULL,
      NULL,
      0.041820,
      1,
      9.824103,
      3,
      1.819763,
      NULL,
      NULL,
      NULL,
      5.678036,
      NULL,
      NULL,
      6.262978,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.003847,
      NULL,
      3.934100,
      NULL,
      1.525909,
      0.247039,
      NULL,
      3.775584,
      1.004101,
      1.274490,
      0,
      NULL,
      1,
      0.866806,
      1.223201,
      0.402685,
      1.709915,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.498094,
      '3130',
      '42211',
      '',
      1,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      4.439967,
      3.779202,
      NULL,
      2,
      0.110706,
      2,
      0,
      0.119755,
      0);
commit;
end;
/


