set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502280';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '412',
      '21401013',
      31,
      NULL,
      '2344243',
      NULL,
      1,
      NULL,
      1,
      '301431',
      NULL,
      ' 8-18-1995',
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.861439,
      0,
      0.541352,
      1,
      0.651790,
      NULL,
      1.728675,
      NULL,
      0.327171,
      NULL,
      NULL,
      0.018812,
      0.564578,
      1.558456,
      1.349376,
      5.868239,
      0.088473,
      1.224791,
      1,
      1.773139,
      NULL,
      5,
      NULL,
      2.629159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.318813,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.934364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.547224,
      0.240169,
      0,
      1,
      0.774597,
      NULL,
      1,
      1.868081,
      0,
      1.971705,
      1,
      0,
      NULL,
      1.514997,
      1,
      0,
      0,
      1.104309,
      1.774637,
      NULL,
      0.450766,
      2.342767,
      NULL,
      NULL,
      0,
      NULL,
      3.020805,
      2.856219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.735848,
      3,
      0,
      6.544500,
      6.062343,
      1.395733,
      1,
      5,
      1.488987,
      3.609518,
      NULL,
      3,
      0.117041,
      1,
      3,
      0.023863,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      1.439394,
      0.988108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.820757,
      0,
      NULL,
      0,
      1.457519,
      2,
      6.825997,
      2,
      1.614037,
      NULL,
      NULL,
      NULL,
      1.831154,
      0.738482,
      3.775726,
      3,
      1,
      NULL,
      0.982199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.051509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.018221,
      1.873034,
      0.262142,
      0,
      1,
      1,
      1,
      2.019156,
      2.775255,
      1.027139,
      1.086750,
      0.761463,
      NULL,
      1,
      0.735113,
      NULL,
      0.444275,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '3002',
      '02212',
      NULL,
      NULL,
      '',
      '',
      '',
      0.121118,
      NULL,
      '',
      '',
      2,
      3,
      1.671315,
      3,
      2,
      3.979019,
      1.572477,
      1.754791,
      NULL);
commit;
end;
/


