set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502280';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-3-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '11222213',
      65,
      7.284405,
      '4232242',
      53,
      NULL,
      3,
      NULL,
      NULL,
      5.892221,
      ' 2-10-1985',
      41.647789,
      33,
      NULL,
      NULL,
      1.845163,
      0,
      0.119117,
      0,
      NULL,
      0.695669,
      0.508103,
      0,
      0.776996,
      1.733374,
      1.488340,
      1.145294,
      1.407604,
      1.668958,
      1,
      1,
      0.771436,
      1,
      0,
      0,
      1.998726,
      1.456445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.964045,
      0,
      0.494711,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.650503,
      1.359291,
      1.616905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.497106,
      1.318686,
      1,
      1.297071,
      1,
      1,
      0.602656,
      1.354974,
      0,
      1.662035,
      1.998456,
      0.403495,
      NULL,
      0,
      0,
      1.023565,
      NULL,
      1.809108,
      0,
      NULL,
      NULL,
      4,
      1,
      1.676130,
      1.944852,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.736782,
      0,
      0.544000,
      1.789498,
      0,
      6,
      2,
      NULL,
      1.149211,
      6,
      4,
      3,
      2,
      2.750860,
      3,
      5.235402,
      NULL,
      0,
      1,
      7,
      1.382464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.279114,
      NULL,
      0,
      1.257277,
      NULL,
      1.660259,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.497699,
      NULL,
      NULL,
      3.352636,
      3,
      2,
      0,
      NULL,
      1.731358,
      0,
      0,
      NULL,
      1.181003,
      1.238192,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4.745411,
      NULL,
      0.416699,
      1,
      0.522731,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.483446,
      NULL,
      NULL,
      1.481821,
      1.201750,
      1,
      1.101533,
      1,
      2,
      3.291887,
      0,
      1,
      1,
      1,
      0,
      0.630221,
      NULL,
      0,
      NULL,
      0.285348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      '10124',
      '',
      0.106472,
      '',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      0.817172,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      3);
commit;
end;
/


