set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502280';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '111',
      '22440011',
      NULL,
      19,
      '0242033',
      100.476629,
      0,
      2,
      NULL,
      '034341',
      5,
      NULL,
      27,
      52,
      0.625291,
      NULL,
      NULL,
      0.925443,
      1.295083,
      0,
      1.973786,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      1,
      1.926866,
      0.288506,
      0,
      0,
      0.213297,
      NULL,
      0.398119,
      0.492759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.149759,
      0.230208,
      0.679064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.194519,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.190210,
      0.874104,
      3.470614,
      2,
      NULL,
      0,
      1,
      1,
      0,
      1,
      1.191215,
      1,
      NULL,
      1.120334,
      1.048056,
      NULL,
      0,
      0.369342,
      NULL,
      1.171454,
      4.507087,
      0.647340,
      0,
      1,
      1,
      1,
      1.004711,
      NULL,
      NULL,
      NULL,
      NULL,
      1.767198,
      1.759739,
      0.403959,
      1.288925,
      0.761482,
      NULL,
      NULL,
      NULL,
      0.290276,
      4,
      4,
      2,
      4.230226,
      2.318110,
      0,
      5.427570,
      NULL,
      0.112272,
      NULL,
      0.360159,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.826872,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.118080,
      NULL,
      NULL,
      2,
      2.146753,
      4,
      3,
      NULL,
      0,
      0.864732,
      0,
      2.208571,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.074048,
      2,
      5.096550,
      0,
      0.865351,
      NULL,
      NULL,
      NULL,
      3.083618,
      NULL,
      1,
      0,
      3,
      0.173085,
      0.352817,
      5.829914,
      0,
      0.668956,
      1,
      NULL,
      1,
      1,
      0,
      0,
      0,
      3.259201,
      3,
      NULL,
      1.404433,
      NULL,
      0.109375,
      0.679887,
      1,
      0.337728,
      NULL,
      1.371463,
      0.341817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.961346,
      '3413',
      '00142',
      '',
      0,
      '',
      NULL,
      '',
      0.727967,
      NULL,
      '',
      '',
      0.188961,
      3.903607,
      3,
      4,
      NULL,
      3.831042,
      2,
      2.753340,
      NULL);
commit;
end;
/


