set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502280';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '400',
      '20101111',
      57,
      43.114877,
      NULL,
      73.687327,
      5,
      3.482845,
      0,
      NULL,
      0.506104,
      ' 9-14-2003',
      NULL,
      NULL,
      1.646492,
      NULL,
      NULL,
      NULL,
      2.851523,
      NULL,
      NULL,
      1.740420,
      0.727767,
      NULL,
      2,
      1,
      1,
      0.881271,
      0,
      NULL,
      0.769183,
      0,
      4.114155,
      NULL,
      0.133475,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      2.871273,
      NULL,
      1,
      1,
      2,
      NULL,
      NULL,
      3.962042,
      1.464830,
      3,
      1.116799,
      2,
      2.949416,
      1.751092,
      0,
      2.608467,
      0,
      1,
      0,
      4.947186,
      1,
      1,
      3,
      0,
      NULL,
      NULL,
      1.644975,
      NULL,
      NULL,
      1.064264,
      0.346229,
      NULL,
      NULL,
      2,
      0.180122,
      1,
      0,
      0,
      NULL,
      1,
      0,
      0.935804,
      0.408794,
      1,
      0,
      1,
      0,
      1.876050,
      NULL,
      0.395847,
      1.582410,
      4,
      NULL,
      NULL,
      0.137124,
      6,
      NULL,
      4.972366,
      3,
      0,
      1,
      0.435225,
      0,
      2.107663,
      0.972733,
      0,
      3.458446,
      4,
      1,
      3.920199,
      4,
      1,
      5.108505,
      6.603228,
      0.361171,
      0,
      2,
      1,
      1,
      1.663292,
      9.590496,
      1.051253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.449371,
      NULL,
      0,
      NULL,
      1.608265,
      1.583436,
      1.567257,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.836452,
      3,
      1,
      0.579322,
      4.978211,
      NULL,
      2.860941,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.419611,
      NULL,
      4.490775,
      1,
      NULL,
      0.921265,
      NULL,
      NULL,
      NULL,
      1,
      0.362691,
      0.480781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.081539,
      0,
      2,
      3,
      3,
      1.819357,
      NULL,
      0.681714,
      1.232403,
      0.073929,
      0,
      1,
      0.576154,
      NULL,
      0.614455,
      0.588864,
      1,
      1,
      0.162824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      '30213',
      '1104',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      NULL,
      2,
      0,
      4,
      4.072195,
      3.164618,
      NULL,
      3,
      1.755993);
commit;
end;
/


