set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502280';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '340',
      NULL,
      35,
      NULL,
      NULL,
      24.592681,
      5,
      1.556198,
      2,
      '031120',
      NULL,
      ' 1- 5-1999',
      14,
      38,
      1,
      NULL,
      1.053292,
      0.901397,
      1,
      1.986797,
      0.427735,
      1,
      NULL,
      1,
      3.123369,
      0.410067,
      3.765031,
      1,
      0.965619,
      1.302212,
      0.993384,
      NULL,
      4,
      NULL,
      1.441391,
      0.979950,
      0.273836,
      1,
      5.706438,
      0,
      3.365874,
      0.486555,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.325296,
      0.182364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.570744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.745903,
      5,
      1.577629,
      4,
      7.553058,
      0.755291,
      0.290015,
      0.452683,
      1,
      NULL,
      NULL,
      0,
      1,
      0.360762,
      NULL,
      0.557778,
      0.231206,
      0.135099,
      0.835991,
      NULL,
      NULL,
      0,
      1.337246,
      3.782816,
      1.658356,
      1.316400,
      3,
      1.703945,
      5,
      1,
      1,
      0,
      5,
      0,
      3,
      1.980199,
      1.954648,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      5.079591,
      NULL,
      4.344708,
      NULL,
      1,
      3.077605,
      2,
      1,
      1,
      9.197193,
      0.153460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.601828,
      NULL,
      1,
      NULL,
      NULL,
      1.173197,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.719384,
      NULL,
      NULL,
      2,
      NULL,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.097058,
      1.232671,
      5.831048,
      0.181480,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.018856,
      8.933268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.401270,
      0,
      2,
      0,
      1.764386,
      0,
      1,
      2,
      3,
      NULL,
      1.773196,
      1,
      1.683363,
      1.974675,
      NULL,
      1,
      1,
      1,
      0.406397,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '02313',
      '3343',
      NULL,
      0.032044,
      '',
      '',
      '',
      1.908332,
      '',
      NULL,
      '',
      NULL,
      0.066599,
      3.246134,
      1.644949,
      1.194867,
      0.261499,
      3.912803,
      3.562399,
      2.541167);
commit;
end;
/


