set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502280';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2210',
      '04303040',
      33.050122,
      50,
      NULL,
      161,
      1,
      NULL,
      0,
      NULL,
      NULL,
      ' 4-11-1987',
      NULL,
      NULL,
      0.440786,
      NULL,
      2.981662,
      0,
      1,
      0,
      1.502692,
      1.476114,
      0.652407,
      1.664017,
      2,
      1,
      1,
      0,
      0.133585,
      NULL,
      NULL,
      1.705345,
      0,
      0.399713,
      1,
      1.250722,
      4,
      0,
      NULL,
      0,
      0.749708,
      1.125900,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.800546,
      1.354423,
      1.201961,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.669524,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.763853,
      0,
      4.584773,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      1.334985,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.846956,
      0.809306,
      NULL,
      NULL,
      1,
      1.228238,
      5.615602,
      NULL,
      0.100917,
      1,
      0.177527,
      7,
      0,
      4,
      1.279520,
      0.778205,
      0.208619,
      5,
      0.116589,
      1.857169,
      NULL,
      1,
      7.508174,
      NULL,
      NULL,
      4.081627,
      NULL,
      7.297004,
      2,
      3.942105,
      1.990310,
      NULL,
      NULL,
      NULL,
      7.373546,
      0.284293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      0.995936,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.115138,
      NULL,
      0.081012,
      3.851932,
      2,
      0.208653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.082166,
      2.950649,
      1.469827,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      3,
      2,
      0,
      NULL,
      0.016022,
      NULL,
      NULL,
      0,
      0.362435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.645343,
      1,
      0.045351,
      1.914245,
      2,
      3,
      NULL,
      NULL,
      0.768095,
      3.749139,
      0,
      0,
      1.702836,
      NULL,
      0.186133,
      1,
      0.243305,
      1,
      1,
      1.024053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.010748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.854418,
      '23310',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      4,
      2,
      1.943721,
      NULL,
      1.795974,
      1.056053,
      1.077349,
      0,
      2);
commit;
end;
/


