set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502280';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2242',
      '32202104',
      3.559561,
      NULL,
      '2324404',
      85,
      1,
      2,
      1,
      '223433',
      NULL,
      ' 5- 3-1994',
      22,
      56,
      0.883940,
      NULL,
      NULL,
      1.053949,
      NULL,
      NULL,
      1.020082,
      0,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1.474832,
      NULL,
      0,
      1,
      1.816127,
      0,
      0.951883,
      0,
      0.111475,
      0,
      0,
      1,
      1,
      3.816398,
      2,
      1.417301,
      0.970505,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.805064,
      0.790468,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.753009,
      1.826850,
      0.086576,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      3.196289,
      4,
      NULL,
      NULL,
      1,
      1.415479,
      0,
      0,
      1.509574,
      1.997512,
      0,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      0.107928,
      4,
      1.772707,
      0.339058,
      0,
      1.723754,
      2.545194,
      0.139980,
      NULL,
      NULL,
      NULL,
      NULL,
      1.037700,
      NULL,
      NULL,
      1,
      NULL,
      0,
      5,
      NULL,
      4.956458,
      NULL,
      3,
      2.642047,
      4,
      5,
      1.795705,
      3,
      NULL,
      NULL,
      NULL,
      9.119782,
      0.240515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.527722,
      NULL,
      1,
      0.851048,
      NULL,
      2,
      NULL,
      0,
      1.133100,
      NULL,
      NULL,
      NULL,
      3.098890,
      1.342239,
      NULL,
      5.188092,
      NULL,
      NULL,
      0.415255,
      NULL,
      NULL,
      NULL,
      1,
      7.097814,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015498,
      0,
      2.845978,
      0,
      3,
      1,
      1.293147,
      3.009472,
      1,
      2.463062,
      1.666151,
      0.261316,
      1.011381,
      NULL,
      1,
      1,
      1.898366,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.106383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '41234',
      '4142',
      NULL,
      0,
      '',
      '',
      '',
      1.636016,
      NULL,
      '',
      '',
      2,
      NULL,
      1.612172,
      NULL,
      2,
      1,
      2,
      2.837705,
      NULL);
commit;
end;
/


