set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502280';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0121',
      NULL,
      NULL,
      NULL,
      '2142432',
      12,
      0,
      2,
      2,
      '323420',
      4.332074,
      NULL,
      21.169877,
      18,
      0,
      NULL,
      0,
      0.644542,
      3.166227,
      1,
      0.658018,
      0,
      0,
      NULL,
      1,
      1.114703,
      0.188732,
      1.717297,
      1,
      NULL,
      1.352702,
      0.742408,
      3.242169,
      1.961387,
      NULL,
      0,
      1,
      1.437190,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.293474,
      0,
      0.786944,
      0.862930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.077614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.071365,
      1,
      0,
      0.323891,
      1,
      NULL,
      NULL,
      1.532712,
      1.061121,
      0,
      1.519019,
      0,
      0.833734,
      1,
      NULL,
      NULL,
      1.589709,
      NULL,
      1,
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.702995,
      2.342447,
      4.227527,
      0.968282,
      1.179389,
      NULL,
      NULL,
      2.839943,
      0,
      NULL,
      2.304643,
      5,
      2.594415,
      2,
      0,
      1.462511,
      1.522802,
      NULL,
      NULL,
      NULL,
      0.805517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.903492,
      1,
      0,
      NULL,
      1.665211,
      NULL,
      1.542791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.616724,
      NULL,
      NULL,
      NULL,
      NULL,
      4.107121,
      3.555911,
      2,
      NULL,
      0.327321,
      2.952935,
      2.165837,
      1.270820,
      NULL,
      NULL,
      NULL,
      NULL,
      0.414101,
      0.155657,
      0.427750,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.031932,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.102416,
      1.062950,
      0.681482,
      0,
      0.921939,
      3.453341,
      2.535089,
      3,
      0.538974,
      1,
      1,
      0.222713,
      NULL,
      1.811229,
      0.445876,
      0,
      NULL,
      1.939717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      '2034',
      '',
      1.267185,
      '',
      NULL,
      NULL,
      0.323184,
      '',
      '',
      '',
      4,
      1.848873,
      1.821339,
      3,
      3,
      3,
      NULL,
      NULL,
      1);
commit;
end;
/


