set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8818590';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0343',
      '03420313',
      NULL,
      19.659507,
      '1324311',
      8.464495,
      6,
      NULL,
      3,
      NULL,
      4,
      ' 6-21-1995',
      41.572708,
      59,
      1,
      NULL,
      2.021974,
      3,
      1.107761,
      1.421524,
      3.039004,
      0,
      NULL,
      1.602253,
      NULL,
      NULL,
      0.794350,
      0.211253,
      1,
      0,
      1,
      1.805595,
      1,
      0,
      1,
      NULL,
      NULL,
      1.481951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.583110,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.023377,
      1.835383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.347185,
      1.889487,
      0.249820,
      3.945058,
      0.510243,
      NULL,
      0,
      1.191749,
      0,
      1,
      1.226491,
      1,
      0,
      0.779384,
      0.396058,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      0.431913,
      1,
      1,
      1.468907,
      0.592258,
      1,
      4.212327,
      NULL,
      4,
      NULL,
      0,
      1,
      1.925517,
      0,
      NULL,
      1.614544,
      NULL,
      0.038806,
      1.190333,
      1.501147,
      4,
      0.022163,
      4.159373,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      7.343856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.142155,
      1,
      0,
      0,
      1.469145,
      0.415725,
      1.882323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.647445,
      NULL,
      NULL,
      NULL,
      NULL,
      0.401885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.631467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.380428,
      NULL,
      1.608660,
      0.115982,
      0.417787,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.852200,
      0,
      0.929068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.144824,
      1,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1.115122,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      1.946456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.896748,
      '40200',
      '',
      '',
      0,
      '21131',
      '',
      '',
      0.562042,
      '',
      '',
      '',
      0,
      0.940853,
      1.529229,
      0,
      NULL,
      3,
      1,
      1.450744,
      NULL);
commit;
end;
/


