set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8818590';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3010',
      '43044240',
      NULL,
      36,
      '2403304',
      14.587191,
      2,
      3,
      0,
      '440104',
      0.053260,
      ' 4-17-1988',
      2,
      60,
      1,
      NULL,
      12,
      1.735683,
      0.647557,
      0,
      1,
      0,
      0.213305,
      1,
      1,
      NULL,
      0,
      1,
      0,
      0,
      0.142444,
      NULL,
      2.988849,
      1.151249,
      1.427702,
      0.009756,
      NULL,
      1.649320,
      1.667341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.280874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.112460,
      0,
      NULL,
      1.110373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.201482,
      0.156658,
      3,
      2.794010,
      4,
      1.623115,
      NULL,
      0.414112,
      1.614710,
      1,
      1,
      1.456107,
      1,
      NULL,
      0.832146,
      NULL,
      1,
      0,
      1.439197,
      NULL,
      0.325234,
      NULL,
      0.450727,
      0.259665,
      1,
      NULL,
      1.861281,
      1,
      2,
      0.468364,
      0,
      1,
      0.317156,
      3.454514,
      0,
      1,
      0,
      NULL,
      0,
      0,
      0,
      3.446786,
      3.348138,
      4,
      3.164084,
      1.882422,
      1.321254,
      3.970001,
      0.229114,
      NULL,
      NULL,
      8,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      1.823254,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.263681,
      NULL,
      NULL,
      NULL,
      NULL,
      0.128613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.800836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.453990,
      1.011157,
      1.408398,
      1.927090,
      NULL,
      NULL,
      1.195442,
      NULL,
      NULL,
      NULL,
      0,
      1.514820,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.919719,
      1,
      0,
      0,
      3.991282,
      1.136065,
      0,
      0,
      1,
      3.357360,
      0.188088,
      1.837247,
      1,
      0,
      1.598055,
      NULL,
      0.894840,
      1.508190,
      0,
      1.708394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.368745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.082802,
      NULL,
      '',
      '',
      NULL,
      '44202',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      4.558767,
      2.768194,
      0,
      0.803874,
      NULL,
      0,
      2,
      2.962922,
      1.762245);
commit;
end;
/


