set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9846199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '20114140',
      34.654618,
      3,
      '2301312',
      NULL,
      1,
      2,
      0,
      '311220',
      2,
      ' 8-25-1994',
      16,
      47.560867,
      0.187297,
      NULL,
      0.070118,
      0,
      2,
      1.220669,
      NULL,
      1,
      1,
      NULL,
      1.009709,
      0,
      NULL,
      0,
      1,
      1,
      0,
      1.114209,
      3,
      NULL,
      NULL,
      0,
      0.307311,
      1.056348,
      1.444639,
      NULL,
      2.808580,
      0,
      0,
      0.754147,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.177886,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.811323,
      0,
      0.468559,
      0.035006,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.210125,
      1.373809,
      1,
      0.675793,
      0,
      1.199868,
      1,
      0.911084,
      0,
      2,
      0.926504,
      0,
      1,
      0,
      1.975828,
      NULL,
      0.800552,
      0.847623,
      1,
      NULL,
      0.180625,
      NULL,
      0.909158,
      NULL,
      0.574966,
      0,
      0.687350,
      0.026712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.068216,
      1.012109,
      3,
      2,
      NULL,
      2.198665,
      NULL,
      1,
      2.235084,
      7,
      5.768336,
      4,
      4,
      4,
      1.774853,
      0.711515,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.470077,
      1,
      0,
      0.991865,
      1,
      0.008416,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.402487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.581506,
      3.695998,
      1.665009,
      NULL,
      NULL,
      NULL,
      1.139736,
      2.225275,
      6,
      8.181605,
      5,
      0,
      0.993384,
      NULL,
      NULL,
      NULL,
      0.796841,
      7.946143,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.155820,
      NULL,
      0.722599,
      0.300568,
      0,
      2,
      2.524906,
      0.208347,
      NULL,
      0.257473,
      3.589790,
      1.710381,
      1.143620,
      1.591820,
      0,
      0.162782,
      0.555459,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '20300',
      '44103',
      NULL,
      0.742596,
      '04121',
      '',
      '',
      0,
      '0111',
      '',
      '',
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      3.776946,
      3,
      3.587435);
commit;
end;
/


