set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9846199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2031',
      '14013111',
      88.726898,
      51.653373,
      '3414004',
      NULL,
      NULL,
      0.279161,
      NULL,
      '400304',
      3,
      ' 3-22-1989',
      23,
      38.303893,
      0,
      NULL,
      0.576696,
      NULL,
      0.422203,
      1.864043,
      0,
      1,
      1,
      0.671901,
      1.181696,
      1,
      3,
      0.911620,
      0,
      1.227928,
      0.231185,
      2,
      6.915763,
      1,
      NULL,
      1.766691,
      0.780897,
      1.417266,
      6.311195,
      0,
      3,
      2,
      0.256647,
      1.199053,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.515973,
      0.529634,
      1.551720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.925421,
      0,
      0,
      1.566332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.669829,
      0,
      0.437159,
      NULL,
      0,
      0.364158,
      1,
      0,
      1,
      1,
      0.170556,
      0.116596,
      1,
      1.067960,
      1.011760,
      NULL,
      0,
      1,
      0.632858,
      NULL,
      1,
      4,
      1.643134,
      0,
      1.334364,
      1.170291,
      2.340796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.692703,
      0,
      0.592369,
      2.226938,
      NULL,
      6,
      6,
      7.524953,
      NULL,
      8,
      NULL,
      1.678690,
      0,
      0.993299,
      0,
      3.060364,
      1.154953,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.457292,
      NULL,
      0,
      1,
      0,
      1.883878,
      0.692376,
      0.207296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.613079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.292231,
      1,
      NULL,
      NULL,
      NULL,
      1.061559,
      1.947494,
      6.693344,
      1,
      1.114987,
      0,
      1.843639,
      NULL,
      NULL,
      NULL,
      NULL,
      0.301239,
      0.072414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.761257,
      2.199137,
      0,
      NULL,
      NULL,
      0,
      1,
      1.422290,
      3.207206,
      3,
      1,
      NULL,
      0,
      0.925223,
      1.351296,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.617947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.099624,
      '23140',
      '10302',
      '',
      0,
      NULL,
      '',
      '',
      3,
      NULL,
      '',
      NULL,
      4.189000,
      5,
      1,
      NULL,
      3,
      1,
      2,
      3,
      NULL);
commit;
end;
/


