set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      NULL,
      NULL,
      '2114123',
      29,
      6,
      1.075713,
      2,
      '121334',
      1.694799,
      ' 1-29-2003',
      39,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2.512953,
      0,
      1.470487,
      NULL,
      NULL,
      1.594468,
      0.147788,
      1,
      7,
      NULL,
      2.814761,
      1.357844,
      1.158856,
      1.115041,
      NULL,
      0,
      1,
      1.604350,
      0,
      1,
      7,
      NULL,
      4.825488,
      1.514289,
      0.728471,
      0.654546,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.407374,
      1.884130,
      1,
      1.745886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.316406,
      NULL,
      0.074359,
      1.129858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.937821,
      0.709623,
      0.373480,
      1.561805,
      1.990761,
      0.063095,
      1,
      0,
      1,
      NULL,
      0.261164,
      0.993389,
      NULL,
      0.663543,
      1,
      1.656491,
      1,
      NULL,
      1,
      NULL,
      1,
      4,
      1,
      1.209686,
      2.997978,
      0.032954,
      NULL,
      1.213626,
      4.533969,
      1.956697,
      NULL,
      NULL,
      0,
      0,
      5,
      1,
      NULL,
      4.253825,
      6,
      2.453589,
      5,
      6.437823,
      3,
      9,
      0,
      4.740684,
      NULL,
      2.460298,
      3,
      0,
      0.236623,
      3.889909,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1.107619,
      NULL,
      1.144560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.299549,
      NULL,
      NULL,
      NULL,
      NULL,
      3.537162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.522710,
      0,
      NULL,
      NULL,
      NULL,
      3.953013,
      1.847784,
      4,
      0,
      0.786521,
      2,
      1.926709,
      NULL,
      NULL,
      NULL,
      0.952524,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.664307,
      1,
      3.454814,
      3.298056,
      3.275407,
      1.155087,
      1.615539,
      NULL,
      1,
      1.392133,
      1.089837,
      1.584998,
      1.419831,
      1.957785,
      0,
      1,
      1.947607,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.745675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.507053,
      '44120',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0.208450,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


