set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '000',
      '11',
      NULL,
      4.178695,
      '1144041',
      36,
      NULL,
      0,
      2,
      '414003',
      4.499016,
      ' 6- 0-2001',
      0.887464,
      38.368443,
      1,
      NULL,
      0,
      0,
      1,
      1,
      1.205346,
      2,
      1.273273,
      1,
      3,
      1,
      2.111333,
      1,
      NULL,
      1,
      0,
      2.213400,
      0,
      1,
      1,
      0,
      6,
      2,
      NULL,
      1,
      1.366623,
      2.184313,
      1,
      1.858296,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.059884,
      0,
      1,
      0.081653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.099302,
      7.268934,
      0,
      1,
      0,
      NULL,
      1.139821,
      NULL,
      NULL,
      NULL,
      1.372249,
      NULL,
      NULL,
      1.049236,
      0.810192,
      0,
      NULL,
      NULL,
      1.822147,
      0.847880,
      0.570607,
      NULL,
      0,
      0.793512,
      0.239749,
      1.260023,
      0,
      0.604507,
      0.372680,
      1.157120,
      0.582072,
      0,
      NULL,
      0.473870,
      NULL,
      1,
      1.334359,
      0,
      NULL,
      2,
      0.880398,
      3.984701,
      NULL,
      1.736920,
      3.353538,
      NULL,
      NULL,
      0,
      1.699389,
      1.875946,
      2,
      NULL,
      2.132017,
      0,
      4.229204,
      5,
      5.527347,
      0.798161,
      NULL,
      0.628846,
      0.894907,
      0.452240,
      NULL,
      1.768648,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      0,
      0.043526,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.979728,
      0,
      4,
      0.543286,
      1.359435,
      NULL,
      1.626674,
      1,
      4.636335,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.681876,
      2.258904,
      1.724409,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1.830103,
      1.831228,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.690677,
      0.783235,
      3,
      3.048712,
      NULL,
      2,
      1,
      2,
      NULL,
      2,
      1,
      1,
      1.593774,
      0,
      0.814431,
      0,
      0,
      1.949608,
      0.728605,
      0.129371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.685375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '24211',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


