set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-2-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '241',
      '14',
      12,
      3,
      NULL,
      133.590499,
      NULL,
      2.937894,
      NULL,
      '423441',
      NULL,
      '10-13-1980',
      NULL,
      NULL,
      0.757699,
      NULL,
      2,
      NULL,
      1,
      0.183422,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.101559,
      6.416359,
      1.945327,
      0.110392,
      0.540241,
      NULL,
      NULL,
      0,
      1,
      4,
      1,
      5.823754,
      1.924089,
      7,
      1,
      0.104595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.350947,
      1.570984,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.020113,
      0.497968,
      0,
      NULL,
      1,
      NULL,
      0.570215,
      NULL,
      0.079882,
      0,
      1,
      NULL,
      1,
      0.928028,
      0,
      0,
      1,
      0,
      1,
      NULL,
      0,
      3.797860,
      NULL,
      NULL,
      NULL,
      1.276093,
      NULL,
      0.989495,
      NULL,
      1,
      5.859146,
      1.280770,
      1,
      NULL,
      5.583307,
      1,
      3,
      5,
      NULL,
      1.880401,
      0.870160,
      1,
      6,
      NULL,
      6.128333,
      0.142075,
      4.139116,
      4.720803,
      3.001058,
      1.631210,
      1.999508,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.092983,
      NULL,
      1,
      0,
      1,
      1.399314,
      0.798035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.314729,
      NULL,
      NULL,
      NULL,
      NULL,
      0.450930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.773607,
      NULL,
      4,
      2,
      1.503138,
      NULL,
      NULL,
      NULL,
      0,
      3.627906,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.568553,
      NULL,
      0.131122,
      2,
      1,
      NULL,
      1,
      1,
      1.758036,
      0,
      1.078805,
      0.425084,
      1.193426,
      1.241304,
      NULL,
      0,
      0,
      1.520108,
      1.811423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.057535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.319727,
      '43133',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3.067332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


