set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-8-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '021',
      '41',
      45.021483,
      13,
      '1442022',
      51.974607,
      0,
      1.881767,
      2,
      '002432',
      NULL,
      ' 5-12-1993',
      40.562123,
      37.412838,
      0.902140,
      NULL,
      1.198786,
      NULL,
      NULL,
      0.484826,
      1,
      1,
      0,
      0,
      0,
      NULL,
      3,
      0.256870,
      0,
      1.854680,
      NULL,
      1.832634,
      NULL,
      1.386581,
      6.921713,
      NULL,
      4.737278,
      0,
      NULL,
      1,
      3.640562,
      2,
      0.909399,
      1.833520,
      NULL,
      NULL,
      0.404893,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.792533,
      0,
      2,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.673970,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.100661,
      1,
      NULL,
      1,
      0,
      NULL,
      1.098403,
      0.575060,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.927158,
      NULL,
      NULL,
      0.749973,
      1.992481,
      0.164174,
      4,
      1.590138,
      5,
      1.246852,
      2.395418,
      5.496746,
      NULL,
      1.201080,
      1,
      0.250899,
      NULL,
      NULL,
      2.655652,
      NULL,
      1,
      4,
      5.754690,
      4,
      NULL,
      NULL,
      1,
      1.534378,
      NULL,
      0,
      0.896596,
      2.100864,
      0.964470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.145693,
      1,
      1,
      0.771553,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.006547,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.098069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.343664,
      1,
      2.475952,
      4.265946,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.543004,
      NULL,
      0.027309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.979251,
      3.154400,
      1.831810,
      0.609370,
      3.187385,
      3,
      1,
      NULL,
      0.900451,
      2.364912,
      0.498629,
      0,
      1.184359,
      0.185468,
      1,
      NULL,
      1,
      1,
      0.094985,
      0.259939,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


