set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-2-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '03',
      10,
      25,
      '2421310',
      NULL,
      4,
      1.617395,
      NULL,
      '301314',
      2.176421,
      '10- 5-1982',
      54.808320,
      7.670351,
      0.750488,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      2,
      0,
      0,
      0.748005,
      0,
      0,
      0.327339,
      5.931738,
      0,
      2.585441,
      NULL,
      1,
      4,
      3,
      1,
      NULL,
      NULL,
      3.481737,
      1,
      1.083833,
      NULL,
      NULL,
      1.035452,
      NULL,
      NULL,
      0,
      1,
      0,
      0.048246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.774610,
      1,
      2,
      NULL,
      1,
      1.010001,
      1.526791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0.496708,
      0.778081,
      0.766178,
      0.737182,
      0,
      1,
      0.159095,
      0.468391,
      0,
      0,
      0.014239,
      0.060787,
      1,
      1.142433,
      NULL,
      NULL,
      1.193790,
      NULL,
      0.773467,
      0,
      1,
      NULL,
      3.283520,
      0.878938,
      2.327135,
      NULL,
      4,
      5.948994,
      0.144669,
      1.666154,
      5,
      0.474905,
      0.676478,
      2,
      NULL,
      1.687752,
      3.294397,
      7.647256,
      3.449917,
      3.745459,
      4.154128,
      0.351133,
      NULL,
      0,
      1,
      NULL,
      1.424792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.317998,
      0,
      0,
      NULL,
      0.489651,
      0,
      0.967088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.020539,
      NULL,
      NULL,
      NULL,
      NULL,
      1.050619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.360744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.513465,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.460165,
      1.234577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.557721,
      0.728342,
      2,
      1.696057,
      1,
      2,
      0,
      3.784346,
      2.161876,
      NULL,
      NULL,
      0,
      1,
      0.519474,
      0.803352,
      0,
      0,
      0.661286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.530385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '30210',
      NULL,
      '',
      1.305495,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      4.989535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


