set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '211',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3.291846,
      1,
      '203321',
      4,
      ' 8-16-1991',
      35.812590,
      54,
      NULL,
      NULL,
      1,
      NULL,
      0.328246,
      0.651981,
      1.974267,
      0.092948,
      1,
      1.066366,
      NULL,
      1.778725,
      5.679854,
      NULL,
      1,
      0,
      1.419514,
      2,
      3.798380,
      0,
      NULL,
      0,
      3,
      1.351111,
      NULL,
      1,
      NULL,
      2,
      1,
      1.301921,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.513347,
      NULL,
      0.002825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.181166,
      4.404450,
      NULL,
      2.643505,
      0,
      0,
      NULL,
      1.543531,
      NULL,
      NULL,
      0.872862,
      NULL,
      NULL,
      0.308305,
      NULL,
      0,
      NULL,
      0,
      1,
      1.242790,
      0.907114,
      0,
      1.775805,
      1,
      1,
      1.126429,
      0,
      1.593637,
      0.074477,
      1,
      1.321214,
      NULL,
      NULL,
      1.053091,
      5,
      1,
      1.969528,
      0.230513,
      0,
      1,
      NULL,
      1.119018,
      5.748848,
      4.461805,
      1,
      0.459240,
      1.553838,
      NULL,
      NULL,
      2,
      NULL,
      0.260148,
      1,
      5,
      7.612960,
      3.080652,
      NULL,
      2,
      1.431820,
      1,
      0.874087,
      2,
      1,
      0,
      4.591155,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.504669,
      NULL,
      NULL,
      NULL,
      NULL,
      1.984356,
      0,
      0.671443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.209120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.996529,
      0.487054,
      0,
      NULL,
      4,
      0,
      5.542954,
      1.411600,
      NULL,
      NULL,
      0.544504,
      1.719807,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      3.936277,
      0,
      3,
      0,
      3,
      1.467043,
      0,
      0,
      NULL,
      NULL,
      1,
      0.063026,
      NULL,
      0.181469,
      0.447583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '43424',
      '',
      NULL,
      1.658614,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      2.099000,
      1,
      NULL,
      0.043835,
      1.044549,
      NULL,
      NULL,
      1.501415);
commit;
end;
/


