set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '134',
      '14322200',
      NULL,
      25.043623,
      '4342013',
      1.243900,
      1,
      3,
      0,
      '314314',
      3.957265,
      '10-11-1991',
      25,
      52.798050,
      0.895960,
      NULL,
      NULL,
      2.739503,
      0.745157,
      NULL,
      1.603705,
      1.022322,
      1.669290,
      NULL,
      1.087135,
      0.793144,
      3.794785,
      NULL,
      NULL,
      NULL,
      0,
      7,
      0,
      1.351307,
      5.010177,
      0,
      1.882223,
      0.425144,
      3,
      1,
      1,
      0.823012,
      3.976334,
      0,
      NULL,
      NULL,
      1.719348,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.416626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.035316,
      0,
      0,
      NULL,
      1.627247,
      0.077748,
      NULL,
      NULL,
      1.291002,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0.547794,
      0,
      NULL,
      0.654253,
      0.312859,
      1.469698,
      NULL,
      0,
      0.377496,
      NULL,
      0,
      1.154104,
      0.535152,
      1,
      0,
      NULL,
      0,
      4.199576,
      NULL,
      0.278145,
      NULL,
      1.744124,
      3.245893,
      0,
      5.972384,
      NULL,
      5.637845,
      1.379832,
      1.153761,
      NULL,
      1,
      0.336593,
      0.808076,
      1,
      3,
      0.683425,
      2.886102,
      6,
      3.630157,
      0.092731,
      3,
      0.156440,
      NULL,
      0,
      1,
      0,
      1,
      6.459649,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      0.200737,
      1.481614,
      0,
      1.895617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      4.002117,
      NULL,
      1.656510,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.601347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1,
      2,
      0.860347,
      0.313675,
      NULL,
      NULL,
      0.111801,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      0.821553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.770732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.842420,
      '34114',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '3123',
      '',
      NULL,
      NULL,
      3,
      0.172036,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1);
commit;
end;
/


