set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '031',
      '01340243',
      39,
      27.655594,
      '3012011',
      NULL,
      NULL,
      2.642468,
      NULL,
      NULL,
      5.885079,
      ' 5-15-1993',
      12,
      59.306739,
      1.911225,
      NULL,
      1,
      3.487584,
      1.585309,
      1.480668,
      1.245305,
      1.406137,
      1,
      0,
      1,
      NULL,
      4.588385,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      6.677313,
      1.118533,
      NULL,
      1,
      7.519808,
      0,
      5.250184,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1.989428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.014682,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.300898,
      0,
      0,
      1.664571,
      NULL,
      1.611151,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.784209,
      1.950842,
      NULL,
      0,
      NULL,
      0.088496,
      1,
      0.597548,
      NULL,
      NULL,
      5,
      0.268838,
      0.769626,
      3.138077,
      0.164781,
      0,
      1.438116,
      1.662995,
      NULL,
      NULL,
      4,
      0.863680,
      0,
      0,
      0.815632,
      0.002619,
      0,
      2,
      NULL,
      NULL,
      4.070642,
      2.605723,
      0.601113,
      4.182973,
      3,
      NULL,
      NULL,
      0.853158,
      0,
      1.562217,
      4.438710,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.850177,
      0,
      0,
      0.231384,
      0.860874,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.540425,
      0.826186,
      1.289359,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.475365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.069113,
      3,
      1,
      2,
      2,
      0,
      NULL,
      0,
      0.142370,
      0,
      0,
      0,
      1,
      NULL,
      1.365031,
      1.490383,
      NULL,
      1,
      0.245787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.610623,
      NULL,
      '',
      '',
      1.564442,
      '',
      '',
      '',
      NULL,
      '4311',
      '',
      '',
      NULL,
      1.336840,
      1,
      3.395313,
      NULL,
      NULL,
      3.767661,
      1,
      3.000364);
commit;
end;
/


