set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '433',
      '10244134',
      30,
      51.789108,
      '0110402',
      183.694015,
      2,
      0,
      0,
      '034341',
      5,
      ' 2- 1-2001',
      20.801119,
      30.163196,
      0,
      NULL,
      3.879319,
      NULL,
      1.661910,
      0.065082,
      NULL,
      3.057776,
      NULL,
      NULL,
      3.821750,
      1,
      7.773855,
      0,
      0,
      0,
      0.966333,
      NULL,
      4.833651,
      1.026606,
      3,
      0,
      3,
      1,
      7.902229,
      0,
      0.103348,
      2.642218,
      NULL,
      1.116569,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.250344,
      0,
      0.408155,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.684343,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1.207721,
      NULL,
      NULL,
      1.288951,
      NULL,
      NULL,
      0.995870,
      1,
      NULL,
      0.026618,
      1,
      1,
      1,
      0,
      0.650159,
      1.994215,
      1.047876,
      1.442426,
      1,
      0.142573,
      1,
      0,
      0.892882,
      0,
      1.178899,
      NULL,
      1.000872,
      2.052226,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0,
      5.206584,
      0,
      1,
      0.291617,
      1.269328,
      1.444337,
      2,
      1.697315,
      0,
      1.093867,
      NULL,
      NULL,
      3,
      NULL,
      1.792062,
      NULL,
      4,
      3,
      0,
      1.692586,
      3.730522,
      0,
      1.394896,
      6,
      0.568100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0.712107,
      0,
      0.661679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.014231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.760712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      4,
      3,
      2,
      5.442972,
      1,
      NULL,
      NULL,
      0,
      0.018383,
      0.950414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.158500,
      1,
      NULL,
      1,
      1.764284,
      0.861113,
      0.948753,
      1,
      NULL,
      3.777434,
      0,
      0,
      0,
      0.821911,
      0,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '12320',
      '',
      '',
      0.593745,
      '',
      '',
      '',
      2,
      '1211',
      '',
      '',
      2,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1.225456);
commit;
end;
/


