set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '321',
      '33044234',
      9.617798,
      44,
      '2432033',
      204.346995,
      5,
      2.038977,
      3,
      '124004',
      0,
      ' 1-21-1988',
      16,
      NULL,
      1,
      NULL,
      3.066448,
      2,
      1,
      1,
      1.372346,
      2,
      1,
      1,
      NULL,
      1.014274,
      4.781583,
      1.497787,
      1,
      0.775304,
      1.749461,
      3.455098,
      5.934834,
      1.598203,
      5.934171,
      0,
      3,
      0.882728,
      3,
      1,
      0.359620,
      5.054462,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.873892,
      1.290959,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      2.011648,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.940981,
      NULL,
      NULL,
      0,
      0.394203,
      0.549457,
      0.778709,
      0,
      1,
      1,
      1,
      1.655525,
      1,
      0.383428,
      1,
      NULL,
      NULL,
      0.617041,
      0,
      0,
      1.493463,
      1,
      NULL,
      0,
      4,
      1,
      0,
      4,
      0,
      4.363923,
      1,
      2.641723,
      NULL,
      4.904276,
      1.622556,
      1.347424,
      NULL,
      2.799435,
      0.307629,
      0,
      NULL,
      2.111676,
      0.221854,
      0.867554,
      NULL,
      3.296510,
      1,
      3.269308,
      1.022669,
      0.832910,
      0,
      3.145170,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0.086066,
      0.300350,
      0.317347,
      1.368069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.829892,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.610869,
      3,
      NULL,
      3.527451,
      0,
      1.267257,
      0.813951,
      NULL,
      NULL,
      0.021687,
      NULL,
      1.184390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.234055,
      NULL,
      NULL,
      1.033867,
      NULL,
      3.477618,
      0.317364,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      1.930208,
      1.879824,
      1.472184,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.579635,
      '31113',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      2,
      '0243',
      '',
      NULL,
      3,
      4.873177,
      NULL,
      NULL,
      3,
      2.595694,
      NULL,
      0.235908,
      2);
commit;
end;
/


