set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3111',
      '03020403',
      7,
      40.064287,
      '3111113',
      NULL,
      6,
      0.297744,
      2,
      '404024',
      4.969047,
      ' 6- 0-2000',
      49,
      6,
      0.768003,
      NULL,
      3.722418,
      NULL,
      1.290602,
      0,
      0,
      NULL,
      NULL,
      1.744191,
      1,
      1,
      NULL,
      1,
      0,
      0,
      0.896563,
      6.649330,
      2,
      0.780528,
      2.053929,
      1,
      NULL,
      0,
      6,
      0,
      0,
      2.283476,
      NULL,
      0,
      NULL,
      NULL,
      1.371921,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.536605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.646275,
      0,
      1.917093,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      1.512258,
      NULL,
      NULL,
      1,
      0,
      0.855299,
      1,
      1,
      0,
      NULL,
      1.641350,
      1,
      0,
      1,
      NULL,
      0.501046,
      0,
      0,
      NULL,
      0.642512,
      1.528606,
      0,
      NULL,
      1.996835,
      NULL,
      1.169194,
      1,
      4.948975,
      1.636429,
      NULL,
      1.009647,
      0,
      1.895551,
      3.505505,
      7,
      0.395633,
      1.097240,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      8.683340,
      3.223665,
      NULL,
      NULL,
      0.174718,
      1,
      4,
      0.488831,
      0.901127,
      0.013018,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.813002,
      1,
      1,
      1,
      0,
      1.943617,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.082906,
      2.269258,
      2,
      1.268448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.678856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      3.579486,
      2.667961,
      2,
      4,
      0.541539,
      NULL,
      NULL,
      1,
      1,
      0.307261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      NULL,
      0,
      1,
      NULL,
      0.721077,
      1,
      NULL,
      1,
      0,
      NULL,
      1.693897,
      1,
      0.257249,
      0,
      1.069571,
      0,
      1.390655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.222714,
      '32233',
      '',
      '',
      1,
      '',
      '',
      '',
      0.654765,
      '4301',
      '',
      '',
      3.330575,
      3,
      0.688983,
      1,
      3.722101,
      NULL,
      3.157222,
      0,
      2.830764);
commit;
end;
/


