set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1242',
      '0',
      55.546765,
      71.039131,
      '1033041',
      266.407312,
      4,
      0.529855,
      3,
      '411032',
      2,
      ' 4-14-1986',
      4,
      47.069834,
      NULL,
      NULL,
      1.213028,
      1.423783,
      0.133168,
      1.140084,
      0,
      0,
      1.090631,
      1,
      0,
      1.850644,
      0.223906,
      0,
      1,
      1,
      1.563776,
      6.807450,
      4,
      0.590842,
      NULL,
      1,
      4.875836,
      1,
      2,
      1,
      0,
      0.126579,
      NULL,
      0.570389,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.012325,
      0.231081,
      0.575339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.085255,
      1.881977,
      1.126715,
      1.922508,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.692040,
      NULL,
      NULL,
      0,
      0.147773,
      NULL,
      0.540963,
      0.487500,
      1,
      1.988662,
      0,
      1,
      1,
      NULL,
      1.537641,
      0.549372,
      NULL,
      0,
      NULL,
      0,
      1.940751,
      0.891681,
      NULL,
      NULL,
      2.106460,
      0.704263,
      1.449465,
      3,
      NULL,
      3.878636,
      0,
      4.349093,
      0.072458,
      4.298561,
      7.755631,
      0.746190,
      0,
      4,
      1.730854,
      1,
      0.580005,
      0.321138,
      2.735829,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      0.657464,
      NULL,
      2.996852,
      1,
      0.038326,
      NULL,
      0.764426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.156745,
      NULL,
      1,
      0.802919,
      0,
      0,
      0.532282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.544076,
      NULL,
      6,
      1,
      3.302671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.863116,
      2.229901,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.240375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.684005,
      0.896351,
      NULL,
      3.678320,
      1.611244,
      0,
      0,
      3,
      0,
      NULL,
      1,
      0.660283,
      0,
      1,
      NULL,
      1.882567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.189292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '00142',
      '',
      NULL,
      1,
      NULL,
      '',
      NULL,
      2.173225,
      '1324',
      '',
      '',
      4,
      3,
      2,
      3,
      3,
      3.587800,
      0,
      NULL,
      2.927041);
commit;
end;
/


