set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4141',
      '30242332',
      55.471677,
      54,
      '4220221',
      110.820577,
      5,
      1.132346,
      NULL,
      '043210',
      NULL,
      ' 9-27-1997',
      43,
      NULL,
      1,
      NULL,
      0.963396,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      0.779313,
      0.068991,
      1,
      0.194113,
      0.419257,
      1.129125,
      NULL,
      4,
      NULL,
      NULL,
      3.659338,
      0,
      NULL,
      0,
      5.857230,
      1,
      1.065761,
      2,
      1.274655,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.626743,
      0,
      4,
      0,
      NULL,
      0,
      1.891339,
      NULL,
      NULL,
      1.018981,
      NULL,
      NULL,
      1.060624,
      1.968676,
      0,
      0,
      1,
      1.454297,
      0,
      0,
      NULL,
      0,
      0.823317,
      NULL,
      0,
      1,
      0,
      1.482125,
      1.380111,
      1,
      1,
      NULL,
      1.308367,
      4.161157,
      0,
      1.624973,
      1,
      1,
      4,
      1,
      NULL,
      0.974628,
      5,
      6.269463,
      0.376178,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      2.345575,
      7.771425,
      NULL,
      0.827203,
      0,
      NULL,
      1,
      NULL,
      5,
      3.084090,
      0,
      0.860639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.030634,
      0.721751,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      2.196971,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.188421,
      1.294936,
      4.431561,
      4,
      3.686127,
      2,
      0.892839,
      NULL,
      NULL,
      NULL,
      0.325955,
      NULL,
      1.995617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.423573,
      3.356236,
      0,
      1.616233,
      3.653244,
      2.190096,
      0.612742,
      1.588278,
      0.845312,
      0,
      0.014586,
      1,
      0.938584,
      1.123646,
      NULL,
      NULL,
      0.165187,
      1.067506,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.687673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.114807,
      '24143',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      '0044',
      NULL,
      '',
      NULL,
      4,
      2.402431,
      1.664640,
      3,
      1,
      3.004450,
      2.565549,
      3);
commit;
end;
/


