set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-12-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      NULL,
      NULL,
      '3024304',
      11,
      1,
      0,
      NULL,
      '210440',
      3,
      ' 2-14-1996',
      31.617449,
      NULL,
      0,
      NULL,
      0.714854,
      1,
      0,
      0,
      1.618721,
      0,
      NULL,
      NULL,
      3.244892,
      1,
      3.319795,
      1.782653,
      NULL,
      0.919543,
      NULL,
      1,
      1.815587,
      1,
      1.037850,
      4,
      0,
      NULL,
      6.168375,
      0,
      0.007663,
      0.498542,
      NULL,
      1.859062,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7,
      2.263664,
      3.473764,
      NULL,
      1,
      1.102362,
      NULL,
      1.836622,
      0,
      1.146954,
      1.831330,
      3,
      0,
      1.779430,
      2.316522,
      0.831976,
      3.528467,
      NULL,
      NULL,
      0,
      4.677624,
      0.603500,
      0,
      2,
      3.219871,
      1,
      NULL,
      NULL,
      0.603938,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.455502,
      4.459256,
      0.906113,
      NULL,
      NULL,
      1,
      1.307513,
      3.416011,
      1.525546,
      1.958927,
      1.903042,
      NULL,
      1.510160,
      1.544256,
      1,
      1,
      NULL,
      NULL,
      1.408405,
      1,
      0.954098,
      0,
      0,
      1,
      1.878971,
      1,
      0.902653,
      0.516289,
      5.791621,
      1,
      1,
      1,
      0.388901,
      NULL,
      6,
      3,
      4.826543,
      NULL,
      5,
      4.179844,
      5,
      6,
      2.973592,
      1,
      5.897165,
      0.721696,
      NULL,
      1,
      NULL,
      0.347830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.430685,
      NULL,
      0,
      2.750715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      1.744595,
      3.052535,
      2,
      0.881058,
      0.911346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.873227,
      1.051310,
      1,
      1.416927,
      5,
      1,
      0.999200,
      0.964027,
      1.549071,
      0,
      0.205285,
      1.229945,
      0.476959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1.625047,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      1.794474,
      NULL,
      0,
      1,
      0,
      0.749754,
      1,
      0,
      NULL,
      NULL,
      1.202616,
      1.179972,
      1.699193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.731978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '03204',
      '',
      '',
      1.789322,
      '',
      '',
      '',
      0.913159,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


