set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      NULL,
      NULL,
      '1424234',
      19.346948,
      5,
      NULL,
      0,
      '310304',
      NULL,
      ' 8-24-1982',
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.062347,
      0,
      0.032862,
      1,
      0,
      0.319516,
      0.136413,
      2,
      1.110254,
      2,
      NULL,
      1.872072,
      NULL,
      1,
      NULL,
      4.046775,
      0,
      0,
      1,
      1,
      0.779292,
      NULL,
      0,
      NULL,
      NULL,
      0.304288,
      1,
      NULL,
      NULL,
      1.302818,
      NULL,
      NULL,
      4.858455,
      5.162887,
      0.910721,
      0,
      1.966646,
      1,
      1,
      1,
      3,
      2.581012,
      3,
      NULL,
      0,
      NULL,
      1.767674,
      2.409484,
      1,
      NULL,
      1,
      0.101577,
      1,
      4.420677,
      NULL,
      0,
      NULL,
      0.562914,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.358434,
      0.413459,
      0,
      1,
      3,
      0,
      1.505255,
      0,
      NULL,
      3.657194,
      NULL,
      1,
      2.866208,
      0,
      0.263912,
      1.223381,
      NULL,
      1,
      NULL,
      1.139077,
      1.898045,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      1.347748,
      1.678538,
      0.154318,
      4,
      0,
      1,
      2.848763,
      1,
      5.015438,
      4.675981,
      NULL,
      4,
      0,
      NULL,
      NULL,
      4.476958,
      4,
      1.485007,
      4,
      NULL,
      NULL,
      1,
      0.425145,
      6.371653,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.353522,
      2,
      0,
      NULL,
      0.424142,
      0,
      0.179435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.935950,
      1.684996,
      0,
      3,
      1,
      1,
      0.834993,
      NULL,
      NULL,
      NULL,
      1.766670,
      1,
      0.372867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.184311,
      0.668714,
      0.080303,
      NULL,
      3.179233,
      1,
      2,
      0.468171,
      1,
      0,
      1,
      0,
      1.908419,
      NULL,
      0.699431,
      0.990100,
      NULL,
      NULL,
      0.878312,
      0.936639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.827740,
      '42023',
      NULL,
      '',
      1.062941,
      NULL,
      '',
      '',
      0.859457,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


