set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-12-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      NULL,
      NULL,
      30,
      5,
      NULL,
      1,
      '114441',
      3.188585,
      NULL,
      25.990579,
      NULL,
      1.924546,
      NULL,
      1,
      2,
      NULL,
      1.936907,
      0,
      0.416849,
      NULL,
      1.148250,
      3.701989,
      1,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      11,
      NULL,
      NULL,
      1.439554,
      1.658229,
      1.516114,
      NULL,
      0,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1.461923,
      NULL,
      NULL,
      3.909719,
      NULL,
      4,
      1.517005,
      1,
      1.980026,
      1.830750,
      1,
      3.837632,
      1.783789,
      3.263880,
      0,
      1.488998,
      1,
      NULL,
      0.427906,
      1.630150,
      1,
      1,
      1,
      NULL,
      0.503112,
      NULL,
      NULL,
      1,
      1.036730,
      1.542370,
      NULL,
      NULL,
      0.583380,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.324126,
      NULL,
      0.346103,
      0.644575,
      NULL,
      1,
      NULL,
      1.840760,
      1,
      1.640233,
      0,
      1,
      1,
      1,
      1,
      0.314373,
      NULL,
      0.045091,
      1,
      NULL,
      NULL,
      0.182557,
      NULL,
      1.300811,
      NULL,
      0.173267,
      1,
      NULL,
      0,
      1.082095,
      1.176676,
      0,
      0.782079,
      1.191474,
      4.475747,
      NULL,
      NULL,
      9,
      NULL,
      3.515335,
      0,
      NULL,
      2.080044,
      NULL,
      2.805116,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.766480,
      0.689575,
      1.408880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.828954,
      NULL,
      NULL,
      NULL,
      NULL,
      0.421454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.237131,
      2.233288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      5,
      0.136532,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.391046,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.530229,
      1,
      NULL,
      3.188500,
      0,
      0.179638,
      0,
      0.550801,
      0,
      0,
      NULL,
      1.280074,
      1,
      1,
      0.658379,
      NULL,
      0.648014,
      NULL,
      1.272793,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '12302',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


