set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-7-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      NULL,
      NULL,
      '4423420',
      46,
      0,
      0,
      0,
      '302233',
      NULL,
      '11- 9-1977',
      52,
      NULL,
      1.160608,
      NULL,
      2,
      3,
      0,
      1.559606,
      1,
      0,
      0.014875,
      1.816325,
      NULL,
      1.740599,
      7.909459,
      NULL,
      1.285227,
      NULL,
      0.176477,
      1,
      5,
      NULL,
      1,
      0.450012,
      0,
      NULL,
      4,
      0,
      2.037910,
      0,
      1.353499,
      0.146212,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.616981,
      6,
      2,
      1.304897,
      0,
      3,
      1,
      3,
      NULL,
      2.887763,
      2,
      NULL,
      1,
      3.516573,
      0.670514,
      NULL,
      1,
      0,
      2.687693,
      NULL,
      1,
      5,
      1,
      2,
      1.750501,
      0,
      NULL,
      NULL,
      0.014343,
      NULL,
      NULL,
      NULL,
      0.766647,
      NULL,
      NULL,
      NULL,
      1.926444,
      1,
      1.707412,
      NULL,
      0.966794,
      NULL,
      1.101000,
      0,
      5,
      0.773289,
      1,
      1,
      1,
      1,
      NULL,
      1.123607,
      1.350971,
      NULL,
      NULL,
      1,
      0,
      0.593855,
      NULL,
      NULL,
      1.025847,
      1.443006,
      1,
      1.983975,
      1,
      1.135956,
      1.768125,
      1.423629,
      7,
      NULL,
      4,
      5,
      10,
      4,
      6,
      8,
      1.726022,
      5.366178,
      2,
      2,
      1,
      0,
      3,
      0.503865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.080122,
      1,
      0,
      1,
      0.062728,
      1.719529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.167924,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      2.493507,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1.539220,
      0,
      0.506772,
      3,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2.838989,
      0.239152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3.134703,
      1,
      NULL,
      2,
      1.418036,
      0.221455,
      0,
      2.346622,
      NULL,
      1,
      0,
      NULL,
      1,
      1.620085,
      NULL,
      1,
      2.974622,
      0,
      1,
      NULL,
      NULL,
      3,
      1.030402,
      0,
      3.892540,
      1,
      1,
      0,
      0.434628,
      1.050775,
      NULL,
      1,
      1,
      1.053067,
      NULL,
      0,
      0,
      0,
      0,
      0.918545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '40424',
      '',
      1.382869,
      NULL,
      NULL,
      '',
      1.506668,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


