set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-12-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      NULL,
      NULL,
      '0300410',
      3.128803,
      2,
      2,
      2,
      '241223',
      2,
      ' 9-13-1990',
      57,
      NULL,
      0,
      NULL,
      NULL,
      2.204266,
      0,
      1.572136,
      2,
      NULL,
      0.271186,
      1.780246,
      NULL,
      NULL,
      5,
      0.937512,
      0,
      0.674720,
      0,
      0,
      1,
      0,
      3.696063,
      1.451372,
      4.526967,
      2.112761,
      6,
      1,
      5,
      1.392915,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8.551444,
      5.704127,
      NULL,
      1.092641,
      3.589515,
      1,
      0,
      1.803753,
      1.780793,
      NULL,
      1.357733,
      3.780816,
      0.947158,
      2,
      0,
      1.091280,
      NULL,
      1.616087,
      0.056832,
      1.946805,
      NULL,
      3,
      9,
      1,
      NULL,
      0.291159,
      1.215204,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.111490,
      0,
      0.193287,
      0,
      0.122269,
      NULL,
      NULL,
      0.093823,
      1.078523,
      4,
      2.772406,
      1.558371,
      1,
      2.742310,
      0,
      NULL,
      1,
      1.364621,
      0,
      NULL,
      0,
      0.508091,
      NULL,
      0.686243,
      1.573861,
      0.631792,
      1,
      0,
      4.578288,
      0,
      0,
      NULL,
      5,
      0,
      3.800068,
      0.159101,
      6.172051,
      0.668865,
      3.610269,
      5,
      6.771417,
      5.069923,
      0,
      2,
      NULL,
      4.836381,
      NULL,
      5.177083,
      0.892580,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.865402,
      0,
      1,
      1,
      1,
      NULL,
      1.793777,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.897580,
      NULL,
      6.469189,
      NULL,
      3.209101,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.623555,
      1,
      6.764261,
      0,
      NULL,
      0,
      0.728828,
      0,
      NULL,
      NULL,
      3.350874,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.324576,
      NULL,
      3,
      2.723683,
      NULL,
      0,
      NULL,
      0.922672,
      1.599457,
      NULL,
      3,
      0.201750,
      0.427339,
      1,
      0,
      NULL,
      1.724642,
      1,
      1.962759,
      NULL,
      1.581023,
      NULL,
      1,
      NULL,
      NULL,
      1.888454,
      2.838411,
      1,
      0,
      1.255688,
      1,
      NULL,
      1,
      2.999778,
      0,
      0.294855,
      NULL,
      1.195274,
      NULL,
      0.299846,
      1.258617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.344549,
      '40403',
      '11414',
      NULL,
      1.029621,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


