set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-6-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      NULL,
      NULL,
      '2334422',
      12,
      NULL,
      NULL,
      2,
      '221010',
      2,
      NULL,
      51.082540,
      NULL,
      0,
      NULL,
      2,
      1.759375,
      0.150162,
      0,
      0.096403,
      NULL,
      1.962485,
      1,
      NULL,
      0,
      4.951270,
      NULL,
      0.910141,
      3.257886,
      1,
      3,
      0,
      0.610366,
      4.581864,
      1,
      1.597808,
      1,
      1,
      0,
      3.798652,
      NULL,
      NULL,
      1.953448,
      NULL,
      NULL,
      0.951266,
      NULL,
      NULL,
      NULL,
      1.932801,
      7.517015,
      2.439733,
      NULL,
      0.252316,
      0,
      1.044976,
      0,
      1,
      1,
      0,
      1,
      1,
      0,
      3,
      NULL,
      1.467816,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2.294352,
      0.271874,
      0.578389,
      1,
      1,
      0,
      1.472038,
      3.174495,
      NULL,
      1,
      1,
      2,
      0.432881,
      0.551066,
      NULL,
      1.762047,
      NULL,
      NULL,
      0.589328,
      0.804216,
      0.225222,
      NULL,
      0,
      1,
      0,
      1,
      2.130096,
      1.352047,
      1.738356,
      1.596596,
      0,
      1.705045,
      NULL,
      0,
      2,
      7,
      4.781515,
      0,
      NULL,
      5.718411,
      2,
      NULL,
      4.370681,
      1,
      8,
      5,
      NULL,
      0.816776,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1.392887,
      0.185557,
      0.780869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4.818988,
      0.580802,
      NULL,
      0.559278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.856360,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1,
      0,
      0,
      0.494414,
      NULL,
      NULL,
      NULL,
      0.446854,
      3.032590,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.047159,
      1.383786,
      1.823717,
      NULL,
      NULL,
      1,
      1.620002,
      3.382953,
      3,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3,
      3,
      0.911237,
      3,
      0,
      2.296586,
      0,
      0,
      1,
      0.677629,
      1.291772,
      0,
      0.477259,
      1.321350,
      1.509135,
      0.509286,
      NULL,
      3.389941,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.010474,
      '44112',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      1.376222,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


