set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-11-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '14',
      33,
      12,
      '1410443',
      NULL,
      4,
      NULL,
      0,
      '243301',
      NULL,
      ' 8-22-1980',
      NULL,
      62,
      1.439514,
      NULL,
      2,
      3.487969,
      NULL,
      1.741082,
      3,
      0,
      0.912910,
      0.161331,
      2.121289,
      1.047592,
      5.054254,
      1,
      1,
      0.194724,
      1.217489,
      1.735403,
      NULL,
      NULL,
      0.378562,
      1.897709,
      NULL,
      1.054360,
      5,
      NULL,
      NULL,
      0.083036,
      NULL,
      1.246920,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.069620,
      0,
      0,
      NULL,
      0.258610,
      0,
      NULL,
      0,
      NULL,
      0.620910,
      1,
      NULL,
      2,
      NULL,
      3.157913,
      1.430202,
      1,
      1,
      1.856070,
      1.397469,
      4.261334,
      3.925627,
      1,
      NULL,
      0.501603,
      NULL,
      NULL,
      NULL,
      0.014094,
      NULL,
      NULL,
      1,
      0.346626,
      4.504607,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0,
      2,
      1.562110,
      0,
      1.524590,
      NULL,
      NULL,
      NULL,
      0.149766,
      1,
      NULL,
      5.663556,
      NULL,
      1.022447,
      3.395104,
      0,
      7.359627,
      0.614257,
      1.786924,
      0.895157,
      0,
      0,
      2.499904,
      1,
      4,
      6.759208,
      7.391805,
      NULL,
      NULL,
      8.582394,
      5.962962,
      1,
      6.454273,
      7.551222,
      9.373101,
      5,
      0,
      0,
      1.255209,
      0,
      1.519387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0.740306,
      NULL,
      0.011664,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.612138,
      3.853396,
      NULL,
      2.950854,
      1,
      0,
      0,
      NULL,
      2.969142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.144366,
      2.145532,
      0.108492,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      6,
      1.719900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.766861,
      2.645687,
      3.252124,
      0.348758,
      0,
      2,
      3.566254,
      1.318712,
      1,
      1.443384,
      1,
      0,
      1.077466,
      1.078036,
      1,
      1.190374,
      1,
      NULL,
      NULL,
      0,
      0,
      0.004620,
      1.326490,
      3.123635,
      3,
      0,
      NULL,
      1.130758,
      3.785137,
      1,
      0,
      NULL,
      0.607774,
      0.798315,
      0,
      2.163744,
      1,
      1,
      1,
      0.577008,
      1,
      0.779810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.144176,
      '43302',
      '41002',
      NULL,
      0.157483,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


