set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12',
      42,
      20,
      '1223214',
      15,
      5,
      2.672073,
      2,
      NULL,
      NULL,
      ' 2-16-1995',
      6,
      59.187816,
      1.231809,
      NULL,
      NULL,
      0.817775,
      1,
      0.484749,
      0,
      3,
      0.366812,
      1.789888,
      1,
      NULL,
      1,
      NULL,
      0.552265,
      0.605948,
      0.119900,
      0,
      3,
      NULL,
      1,
      0,
      NULL,
      0,
      6.614949,
      0,
      4,
      1,
      0.998500,
      0,
      NULL,
      NULL,
      0.036083,
      NULL,
      NULL,
      6,
      0.056694,
      5,
      3,
      1,
      1.858719,
      3.203143,
      1.155997,
      NULL,
      NULL,
      1.044507,
      1.854765,
      1.477675,
      2,
      0.189378,
      NULL,
      0.505764,
      0.943550,
      0,
      0,
      0,
      0,
      4.879031,
      0,
      1,
      1.410084,
      0.022722,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      5,
      1.556387,
      1,
      NULL,
      1.273402,
      1.723275,
      NULL,
      1,
      0.464231,
      1.577170,
      0,
      0.504233,
      2.758683,
      1,
      1.393591,
      0,
      1,
      0,
      NULL,
      1,
      1.734351,
      1.906068,
      0,
      1.687862,
      NULL,
      1,
      1,
      1.833892,
      0.471558,
      0.435244,
      0.372379,
      1,
      0.273577,
      1,
      0,
      NULL,
      NULL,
      5.485922,
      4.526193,
      NULL,
      NULL,
      6.333040,
      8,
      8,
      NULL,
      6.777742,
      2.620010,
      1.406407,
      0.416516,
      1.204831,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.817280,
      1,
      1,
      1,
      1,
      1.172445,
      1,
      1.767067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.895039,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0,
      0,
      2.846771,
      1.255932,
      1,
      NULL,
      NULL,
      3,
      3.170443,
      1.702975,
      NULL,
      3.065105,
      1,
      0,
      NULL,
      0.743656,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.778339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.981826,
      2.888713,
      NULL,
      0,
      1,
      1,
      0.740140,
      NULL,
      0.908726,
      NULL,
      0,
      NULL,
      NULL,
      0.435683,
      0,
      NULL,
      1,
      1.826153,
      1.465693,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.401753,
      2.203431,
      NULL,
      0.952115,
      1.349986,
      0,
      1,
      1.455002,
      0,
      1,
      0.942474,
      0,
      1,
      NULL,
      1.924939,
      1.577147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.945958,
      '04103',
      '31440',
      '',
      1.509408,
      '',
      '',
      NULL,
      1.143807,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


