set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-6-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '00',
      33.906433,
      NULL,
      '0032304',
      14.504925,
      0,
      1.799858,
      1,
      '443013',
      1,
      ' 2- 3-1976',
      37.318305,
      64.119543,
      0,
      NULL,
      0,
      1,
      1.184980,
      1,
      0.166159,
      1.513738,
      NULL,
      NULL,
      3,
      0.455117,
      NULL,
      NULL,
      0,
      0.101776,
      1.895841,
      3,
      1.055974,
      1.678095,
      1.458792,
      0.842323,
      1,
      1,
      4,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      5,
      0,
      3.498747,
      1,
      NULL,
      NULL,
      1.975334,
      1,
      NULL,
      NULL,
      0.182310,
      2.329533,
      0.406782,
      2.387592,
      3.417510,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      7.457215,
      1,
      2,
      1.862425,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.480944,
      NULL,
      1.053326,
      5.353118,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.223314,
      1.243572,
      0.448186,
      1.487334,
      0.916101,
      1,
      1.673164,
      NULL,
      NULL,
      0.946762,
      NULL,
      NULL,
      1.743811,
      1.106107,
      1.021664,
      0.543568,
      NULL,
      3,
      0.174349,
      1,
      1.037526,
      1,
      0.495848,
      0.928785,
      0.323181,
      0,
      NULL,
      3.149500,
      7.332445,
      4,
      3.992232,
      NULL,
      4,
      9.437195,
      3,
      5,
      4,
      3.118313,
      0.002801,
      0,
      5.268451,
      0.996041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.726391,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      0.197779,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      1,
      1.237320,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.840827,
      2.657900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.323776,
      2,
      8.674845,
      1.766438,
      0,
      1.061437,
      NULL,
      NULL,
      NULL,
      NULL,
      4.608984,
      0.540219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.249933,
      2.735877,
      NULL,
      0,
      1.366151,
      2,
      2,
      0,
      NULL,
      NULL,
      3,
      0.680339,
      NULL,
      0.436901,
      0.649714,
      1.349078,
      0.001902,
      1.175562,
      0,
      0.967310,
      NULL,
      0.512949,
      1.652381,
      NULL,
      0.004405,
      NULL,
      NULL,
      NULL,
      0.928375,
      NULL,
      NULL,
      NULL,
      1,
      0.473784,
      0.241751,
      0,
      NULL,
      NULL,
      NULL,
      0.432134,
      1.751594,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '42220',
      '24310',
      '',
      1.646855,
      '',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      0.267453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


