set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-10-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      25.687878,
      NULL,
      '2321243',
      132.857376,
      5,
      NULL,
      1,
      NULL,
      4,
      ' 5-24-1994',
      1,
      23.625241,
      1.957136,
      NULL,
      0.096541,
      0,
      3.036800,
      1.664580,
      0,
      0,
      1,
      NULL,
      3,
      NULL,
      0.167195,
      1.821837,
      0,
      0.781326,
      1.681143,
      NULL,
      6.477003,
      1.831321,
      NULL,
      0.137844,
      0.538876,
      0.512941,
      0,
      1,
      2,
      1,
      0.285608,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.898484,
      NULL,
      3,
      NULL,
      3.716012,
      1,
      NULL,
      1.416263,
      0.266903,
      2.492503,
      2.961648,
      1,
      0,
      2.975858,
      1,
      NULL,
      1.199420,
      0,
      1.130625,
      NULL,
      0.185867,
      4.192769,
      7.454474,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.112719,
      1.475413,
      0,
      NULL,
      2.082482,
      NULL,
      0.144675,
      0.972923,
      1.590058,
      0.323629,
      3.690837,
      0.310883,
      0.127998,
      2,
      0.637890,
      1,
      0,
      0,
      NULL,
      NULL,
      1.877325,
      NULL,
      0,
      NULL,
      1,
      1.162045,
      0,
      0,
      1,
      1,
      0,
      0.538691,
      0.323547,
      0.456182,
      3.590916,
      0.808047,
      4,
      7.010505,
      6,
      7.064925,
      NULL,
      11,
      NULL,
      8.359335,
      5.945204,
      3,
      3,
      NULL,
      1.674241,
      1.011714,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.298183,
      1,
      1,
      NULL,
      1,
      0,
      0.215216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      3,
      2,
      0.697712,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.865132,
      NULL,
      1,
      4,
      2,
      0,
      NULL,
      NULL,
      NULL,
      2.032524,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.571721,
      2,
      2,
      NULL,
      3,
      0,
      0,
      3.020975,
      0,
      1,
      NULL,
      2.099645,
      1,
      NULL,
      1,
      0,
      0.665248,
      1.291971,
      1,
      NULL,
      0.793283,
      1,
      NULL,
      1,
      0.530571,
      2,
      NULL,
      3,
      1.771344,
      1.380125,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      3,
      0,
      NULL,
      0.435053,
      0.228512,
      0,
      0.487451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      '42032',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


