set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-5-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '043',
      '42',
      NULL,
      35,
      '2031100',
      133.000166,
      2,
      NULL,
      1,
      '000444',
      4.215592,
      ' 2-23-2002',
      44,
      21,
      1.199272,
      NULL,
      1.666731,
      1,
      NULL,
      0.644327,
      1,
      0,
      0.137696,
      0,
      NULL,
      1,
      2,
      0,
      3,
      1.110234,
      0,
      0,
      7.163258,
      1.776773,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3,
      0.870814,
      3.590036,
      0.186232,
      NULL,
      NULL,
      0.644106,
      NULL,
      NULL,
      8.644464,
      1.153100,
      NULL,
      3.736290,
      0.676715,
      0,
      3.983206,
      3,
      NULL,
      3.001614,
      2.053634,
      NULL,
      NULL,
      0.182184,
      1.445219,
      1.016549,
      2,
      1,
      0,
      0.911613,
      1,
      1.389949,
      2,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.311960,
      NULL,
      1.894985,
      1,
      0,
      1.428426,
      1.272290,
      NULL,
      1,
      0.644630,
      0.261956,
      0,
      1.874877,
      1,
      NULL,
      NULL,
      1,
      1.289262,
      0,
      NULL,
      1,
      1.175660,
      1.609162,
      0.214319,
      1,
      0,
      1,
      1,
      3.438113,
      1,
      0,
      0.588514,
      1,
      1.373566,
      1.285975,
      1.372998,
      5.078135,
      1.856952,
      2,
      NULL,
      6,
      5,
      5,
      NULL,
      7,
      0,
      7.298681,
      NULL,
      NULL,
      NULL,
      0.755081,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.399614,
      0.016148,
      0,
      1,
      0.033259,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      3,
      0,
      6.727544,
      NULL,
      NULL,
      1.806022,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      0.793994,
      6,
      2,
      1.416471,
      1.949031,
      NULL,
      NULL,
      0,
      15,
      NULL,
      2.848640,
      0,
      2,
      NULL,
      0,
      0.410114,
      0.363054,
      NULL,
      0.659954,
      1,
      NULL,
      NULL,
      3.305702,
      1.695083,
      0.612680,
      0.867409,
      2,
      2.785607,
      1.014396,
      0.272743,
      1.832088,
      1.791869,
      0,
      1.846884,
      1,
      2.323694,
      1.151234,
      1.602523,
      0,
      NULL,
      NULL,
      3,
      3,
      2,
      NULL,
      1,
      0,
      NULL,
      0,
      0.516386,
      1,
      1.255539,
      2,
      1.547214,
      0.925186,
      1.586722,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.184892,
      NULL,
      '23224',
      '',
      NULL,
      NULL,
      '',
      '',
      1.043063,
      '',
      '',
      '',
      1,
      1.429966,
      NULL,
      NULL,
      2.841626,
      2.777564,
      2,
      NULL,
      1);
commit;
end;
/


