set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-12-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '121',
      '42321020',
      46,
      5.101718,
      NULL,
      NULL,
      0,
      2.818014,
      NULL,
      '030201',
      1,
      ' 2-19-1975',
      NULL,
      39.964382,
      NULL,
      NULL,
      2.053033,
      3,
      1.104999,
      0,
      2,
      0.362181,
      1,
      1.992386,
      0,
      0,
      8,
      0.506384,
      1.944370,
      4,
      1,
      1.619402,
      9.126075,
      0.241824,
      1,
      0.817113,
      5.955451,
      1.493016,
      5.742762,
      0,
      2.124605,
      1,
      3.959128,
      NULL,
      NULL,
      NULL,
      0.195417,
      1,
      5.260932,
      NULL,
      5.538959,
      7,
      1,
      0.330530,
      0,
      0,
      0,
      1.800437,
      1,
      2,
      NULL,
      2,
      0,
      NULL,
      1,
      2,
      0.126982,
      NULL,
      0,
      0.842850,
      1.202526,
      8.466284,
      NULL,
      0,
      0.691192,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.050075,
      NULL,
      1.933002,
      0,
      0.580396,
      3,
      0.875289,
      1.801900,
      1,
      0.984416,
      0,
      1.471268,
      NULL,
      1,
      0.763228,
      0,
      0.139852,
      1,
      NULL,
      0,
      NULL,
      1.495672,
      1,
      0,
      1,
      0,
      1,
      1.024553,
      0,
      7.980262,
      0.763048,
      NULL,
      4,
      1.617418,
      0.255390,
      2.712696,
      1.861666,
      6.853609,
      0,
      4,
      6.344613,
      6.260521,
      4,
      11,
      7,
      5.358727,
      3,
      2,
      NULL,
      0,
      0,
      NULL,
      2.988837,
      1.211673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.192668,
      NULL,
      1.645369,
      0.350025,
      2,
      10.490153,
      0.436581,
      0.290962,
      3.101918,
      0,
      9.741705,
      2,
      3,
      0.773041,
      NULL,
      NULL,
      NULL,
      1,
      1,
      7.201790,
      3,
      NULL,
      NULL,
      NULL,
      1.106892,
      NULL,
      NULL,
      3.275554,
      2,
      1,
      4,
      4,
      2,
      1.578837,
      NULL,
      0.411960,
      0,
      2,
      3,
      0.773454,
      0.079638,
      1.427566,
      1.368034,
      2.941939,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0.079719,
      3.173143,
      NULL,
      1.818952,
      0.016340,
      0,
      NULL,
      0,
      0.521745,
      0,
      2.222941,
      0.517502,
      0,
      NULL,
      0.691340,
      0,
      0.214791,
      0,
      1,
      1,
      0,
      2,
      NULL,
      NULL,
      1.514795,
      NULL,
      0.332924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '44220',
      '02303',
      '',
      0.880488,
      NULL,
      '',
      NULL,
      0.569611,
      '',
      '',
      NULL,
      1.609854,
      0.482596,
      2.632326,
      1,
      0.649798,
      0,
      2,
      2.226437,
      3.454451);
commit;
end;
/


