set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '301',
      '14223202',
      30.562680,
      47.497729,
      '0341213',
      79,
      1,
      3.405864,
      0,
      '432231',
      4.691325,
      ' 1-22-1992',
      NULL,
      61.665770,
      NULL,
      NULL,
      2,
      0.876876,
      1.320889,
      0.025571,
      NULL,
      1,
      1.600103,
      1,
      3,
      0.250233,
      5.824630,
      1,
      1,
      1,
      1.089926,
      0,
      1.568380,
      NULL,
      1,
      NULL,
      NULL,
      0.087925,
      4.961400,
      1,
      3,
      1.338975,
      2.910895,
      1.016943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      7.292376,
      3.265025,
      3,
      NULL,
      0.886195,
      1,
      0,
      1,
      3.367503,
      0,
      NULL,
      NULL,
      0,
      3.735426,
      3.792670,
      NULL,
      0.791225,
      0,
      1,
      1.758114,
      2.759187,
      1,
      0,
      1.111965,
      0.447477,
      NULL,
      NULL,
      1.263029,
      NULL,
      NULL,
      0,
      0,
      0.313623,
      NULL,
      NULL,
      1.677130,
      0.768626,
      NULL,
      1.843620,
      1.138794,
      1,
      1.709089,
      1,
      NULL,
      1.910055,
      0.176183,
      0.098124,
      NULL,
      0,
      NULL,
      1,
      0.713366,
      NULL,
      NULL,
      1.096891,
      1.324462,
      0,
      0.836845,
      NULL,
      1,
      NULL,
      0.039581,
      0,
      0,
      5,
      1,
      NULL,
      5.189650,
      7.524599,
      1.214240,
      0,
      8,
      5,
      8.515418,
      NULL,
      1.178303,
      2.836350,
      3.942541,
      3.574170,
      NULL,
      1,
      1.703420,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      0.429417,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      7.854582,
      1,
      0.567810,
      5,
      3.184872,
      0.750624,
      0,
      0.459584,
      0.240641,
      NULL,
      2.952243,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.048297,
      4,
      3.700159,
      6.758546,
      0,
      2.913282,
      1.221471,
      NULL,
      NULL,
      NULL,
      1.392631,
      0.269632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.693342,
      3,
      3.910082,
      3,
      NULL,
      0.166648,
      1,
      3.815248,
      NULL,
      NULL,
      0.789525,
      2,
      0,
      NULL,
      1.303162,
      0.522705,
      1,
      0,
      1,
      3,
      0,
      0.646558,
      1.505169,
      0.479343,
      2,
      2,
      3.891030,
      3.950130,
      1.544777,
      1,
      1.713606,
      0,
      0.817182,
      0.330952,
      1,
      0.477377,
      2.410686,
      1.257102,
      1,
      0.412933,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '20322',
      '04113',
      '',
      0.440126,
      '',
      '',
      '',
      1.052603,
      '',
      '',
      '',
      4,
      NULL,
      NULL,
      0.359244,
      3.684444,
      3.196227,
      2,
      3.640736,
      1);
commit;
end;
/


