set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '00001300',
      12,
      27,
      '3444002',
      13,
      4,
      0,
      1,
      NULL,
      4,
      ' 8- 0-1978',
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      2.055565,
      NULL,
      1.205644,
      1.404643,
      1,
      5,
      0,
      0.984144,
      6.215165,
      0.605244,
      1,
      7.540947,
      0,
      7,
      3,
      7,
      6,
      2.890095,
      1,
      3,
      1.018370,
      2.779715,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      NULL,
      1.560136,
      3,
      NULL,
      3,
      0,
      NULL,
      3.069357,
      NULL,
      NULL,
      0.948338,
      1.235800,
      0,
      2.034146,
      3,
      0,
      1.242676,
      1,
      0,
      5,
      10.285890,
      0,
      NULL,
      3.440660,
      1.002070,
      NULL,
      NULL,
      0.964292,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1.113981,
      2,
      0.185120,
      0,
      1.801706,
      1.001060,
      0,
      1.359274,
      0.197790,
      0,
      1.866203,
      1.959238,
      1,
      NULL,
      1,
      1.275440,
      NULL,
      0.596703,
      1.570625,
      0,
      0.120816,
      1,
      1,
      1.936349,
      1.898377,
      NULL,
      NULL,
      2,
      1.370850,
      1,
      1.040647,
      7.495074,
      1,
      NULL,
      7.423946,
      3,
      6,
      2,
      4,
      2,
      1,
      NULL,
      4,
      7,
      NULL,
      NULL,
      1,
      1,
      2.985118,
      1.259631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.610096,
      NULL,
      0,
      0,
      NULL,
      0.659770,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      1.550441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.344190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.632861,
      2.177181,
      0.176869,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.138365,
      5.039024,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      1.053624,
      0.953948,
      0,
      2.179807,
      0,
      0,
      NULL,
      2,
      3.269120,
      1,
      0,
      NULL,
      1.864121,
      0.396281,
      NULL,
      0.088723,
      2,
      1,
      1,
      1,
      0,
      1.944569,
      1.242563,
      0,
      3.201754,
      1,
      1.156375,
      1,
      0,
      1.532237,
      NULL,
      1,
      1.412046,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      1.469387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '42422',
      '34042',
      '',
      NULL,
      '',
      '',
      NULL,
      1.302062,
      '',
      '',
      '',
      3.267983,
      2,
      3,
      2.934424,
      1,
      1,
      0.048307,
      3,
      1);
commit;
end;
/


