set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '203',
      '12104303',
      56.028115,
      72,
      '0020442',
      129,
      NULL,
      3.560955,
      3,
      '213313',
      0,
      '10- 2-1981',
      41,
      39,
      0,
      NULL,
      3.211087,
      1.070381,
      1.481315,
      1,
      0.981710,
      3,
      1.009740,
      0,
      NULL,
      0,
      0,
      0.494428,
      0,
      6,
      0,
      0.577755,
      6.153194,
      1,
      6.669076,
      1,
      0.093584,
      4,
      7,
      0,
      3.104597,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.784450,
      5.767148,
      3.401984,
      1,
      0,
      0.380255,
      NULL,
      0.651588,
      2.926794,
      0,
      NULL,
      0.552427,
      1,
      1,
      0.931081,
      2.405505,
      3.083961,
      0.959168,
      0.698588,
      2.834030,
      1,
      NULL,
      9.632444,
      1,
      NULL,
      1.947062,
      1,
      NULL,
      NULL,
      1.209382,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.444847,
      NULL,
      1.333672,
      1,
      1,
      0.443871,
      0,
      NULL,
      0.135489,
      0.070347,
      1.376894,
      1.629019,
      1.790818,
      1,
      1,
      NULL,
      0.606289,
      0.183727,
      0,
      1,
      1.909367,
      1.696476,
      1.328001,
      NULL,
      2.932988,
      0,
      1,
      0.353117,
      4.418978,
      1,
      NULL,
      0.814671,
      3,
      7.133796,
      8,
      6.137078,
      2,
      4,
      1.153064,
      1.871803,
      2.486520,
      NULL,
      NULL,
      NULL,
      1.001200,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.412982,
      1,
      1,
      2,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.487725,
      NULL,
      9,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.426842,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      4.812545,
      9.132733,
      0,
      0,
      1.739736,
      0,
      NULL,
      NULL,
      0,
      1.404194,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.100754,
      2.905360,
      1.114653,
      0.120158,
      3,
      3.484162,
      0.369906,
      0,
      1.332432,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0.865773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.990341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '02122',
      '41240',
      NULL,
      0,
      '',
      NULL,
      '',
      0.144424,
      '',
      '',
      '',
      NULL,
      3.093710,
      NULL,
      1.877034,
      0.216568,
      NULL,
      3.121066,
      0.184523,
      0.608654);
commit;
end;
/


