set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      8,
      50.611206,
      NULL,
      21,
      1,
      0.657426,
      3,
      '403042',
      5,
      '11-27-1976',
      1,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.029324,
      0,
      1.082529,
      1.275921,
      1,
      NULL,
      3,
      1,
      5,
      0.003704,
      0,
      1.919257,
      NULL,
      NULL,
      2.108648,
      7.199669,
      7.881808,
      0.466447,
      5.269413,
      4.037892,
      9.884205,
      NULL,
      3,
      0,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.804117,
      NULL,
      NULL,
      1,
      1,
      0,
      3,
      1,
      1.477601,
      NULL,
      0.853116,
      0.465208,
      0,
      0.147360,
      2,
      2,
      1,
      NULL,
      1.627482,
      7.732094,
      0.840946,
      8.278313,
      1.882951,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.794475,
      1.929936,
      NULL,
      NULL,
      4.043983,
      NULL,
      0.728472,
      1,
      0.365466,
      1.071871,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.255965,
      1,
      1.646477,
      NULL,
      NULL,
      1.815210,
      0,
      1.432594,
      0.701547,
      0.693404,
      0,
      5,
      1,
      7.932062,
      2.813094,
      1.831451,
      0,
      NULL,
      1,
      4,
      NULL,
      0.150647,
      0,
      9.173192,
      0,
      9,
      2,
      4,
      7.849483,
      3,
      NULL,
      6.595632,
      1,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.062818,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      NULL,
      3,
      6,
      NULL,
      3,
      1.607208,
      1,
      NULL,
      9,
      0,
      1.849672,
      NULL,
      NULL,
      NULL,
      1.635012,
      2,
      NULL,
      NULL,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      0,
      10,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.895513,
      3.458122,
      0.418228,
      0,
      0,
      2,
      1,
      0,
      0,
      1.813609,
      1.874211,
      1,
      1.637637,
      NULL,
      1,
      NULL,
      1.570010,
      1.018361,
      0.718095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.829891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.184032,
      0,
      0.511120,
      NULL,
      0,
      1.205351,
      0,
      0,
      NULL,
      '10142',
      '31123',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      5.663987,
      5.654676,
      NULL,
      0,
      3.760364,
      2.559165,
      2.994947,
      2.850438,
      NULL);
commit;
end;
/


