set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '020',
      '14221422',
      53,
      16.828280,
      '1244441',
      143,
      3,
      0,
      2,
      '341330',
      4.469957,
      ' 6-20-1988',
      32.656784,
      29,
      1.836677,
      NULL,
      0.707289,
      1.768909,
      3,
      0,
      1.361157,
      0.682291,
      0,
      0.157355,
      0.916667,
      0.580499,
      1,
      NULL,
      1,
      NULL,
      0.759607,
      3.669625,
      2,
      2.366534,
      3.357338,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2.435173,
      2,
      1.918073,
      NULL,
      NULL,
      1.198563,
      NULL,
      NULL,
      NULL,
      4.139188,
      1,
      1,
      NULL,
      0.737897,
      NULL,
      1,
      2.866524,
      NULL,
      3,
      0.819650,
      1,
      3.026836,
      1.508232,
      2.575832,
      3.179067,
      1,
      NULL,
      4.402109,
      1.990746,
      3.668896,
      2.081778,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      1.174681,
      NULL,
      NULL,
      0.431151,
      1,
      3.525955,
      0,
      2.958538,
      1,
      1.735020,
      1,
      1.150411,
      0.198571,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      0.004461,
      0,
      NULL,
      NULL,
      0,
      0.615610,
      1,
      1,
      2,
      1,
      0,
      0,
      7,
      3.423180,
      4,
      1,
      0,
      1.413563,
      3.029296,
      0.387917,
      4,
      NULL,
      9.512081,
      6,
      1,
      9,
      NULL,
      NULL,
      0.110815,
      NULL,
      1.402363,
      NULL,
      1,
      1,
      1.047465,
      5.044528,
      1.168731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.036044,
      0,
      0,
      0,
      1,
      1,
      4.790281,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5.943168,
      NULL,
      2,
      1.018257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1.454903,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.861467,
      0.889994,
      NULL,
      1.933880,
      NULL,
      NULL,
      NULL,
      1.013386,
      5.112232,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.744970,
      NULL,
      2,
      0.228697,
      2.858056,
      0.028976,
      1,
      NULL,
      1.447129,
      0.394000,
      0,
      NULL,
      1.365997,
      NULL,
      1.765339,
      1.861784,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '22431',
      '44021',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      4,
      2.305096,
      NULL,
      3,
      7.471024,
      0,
      2.089040,
      1);
commit;
end;
/


