set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      72.354980,
      NULL,
      NULL,
      119.503272,
      NULL,
      0,
      NULL,
      '444443',
      1.048680,
      ' 2- 2-1977',
      14,
      4.811362,
      0.245512,
      NULL,
      0,
      1,
      NULL,
      0,
      0.284912,
      0,
      0,
      1,
      1.634940,
      0.316385,
      1,
      0.004575,
      1,
      1.098817,
      1,
      2,
      2.339309,
      1,
      0.961562,
      1,
      NULL,
      1.950901,
      NULL,
      1,
      4,
      NULL,
      1.573119,
      1,
      NULL,
      NULL,
      0.478837,
      NULL,
      NULL,
      0,
      0,
      1.969438,
      3,
      NULL,
      1.329434,
      NULL,
      1,
      0,
      NULL,
      2.676387,
      NULL,
      0,
      3.193499,
      2,
      2.713144,
      NULL,
      1,
      1,
      2.032508,
      4,
      0,
      NULL,
      1,
      2,
      0,
      0.179752,
      NULL,
      NULL,
      0.073339,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      0,
      1,
      1.756657,
      1.675716,
      0.315046,
      0.942215,
      0.901901,
      1.302343,
      0,
      1.558025,
      0,
      1.620395,
      1.273622,
      0,
      NULL,
      0,
      3.427690,
      0,
      2.679736,
      2.494290,
      1.093184,
      1.516529,
      1.812792,
      NULL,
      NULL,
      NULL,
      NULL,
      0.780502,
      NULL,
      NULL,
      0,
      3,
      7,
      NULL,
      NULL,
      1,
      7.018606,
      4,
      4,
      0.307681,
      1,
      5.114956,
      3.233254,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.276383,
      1.047630,
      NULL,
      1,
      NULL,
      1,
      1.603540,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.483628,
      1,
      1.073451,
      NULL,
      NULL,
      NULL,
      1.852886,
      1,
      NULL,
      3.822333,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.036763,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.323684,
      0,
      2,
      1.170445,
      1.481643,
      1,
      1.816039,
      1,
      1.162587,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '02412',
      '12130',
      NULL,
      0.697743,
      '',
      '',
      '',
      0.504209,
      '',
      '',
      NULL,
      3.046496,
      4.594025,
      3.091471,
      2.018769,
      0,
      4,
      NULL,
      0,
      0);
commit;
end;
/


