set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '04144114',
      40.150883,
      11,
      '2143331',
      52.305628,
      4,
      2,
      1,
      '304321',
      2.720160,
      NULL,
      52,
      40,
      1,
      NULL,
      2.726816,
      0,
      0.490379,
      1.365376,
      NULL,
      1,
      0.346971,
      1,
      1.015161,
      0,
      3.140790,
      0,
      0.953937,
      3,
      0,
      0,
      6.342185,
      NULL,
      0,
      2.149660,
      NULL,
      5,
      NULL,
      1,
      3.011357,
      0.630110,
      3.085761,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.820426,
      7.861967,
      NULL,
      3.327066,
      NULL,
      0.929711,
      NULL,
      1.220971,
      2.128349,
      NULL,
      3,
      NULL,
      NULL,
      0.062451,
      1.490933,
      2.957102,
      NULL,
      1,
      1.764785,
      2.324883,
      1.377823,
      NULL,
      0,
      1,
      0,
      NULL,
      0.083064,
      NULL,
      NULL,
      0.171431,
      NULL,
      NULL,
      NULL,
      1.928551,
      0.104111,
      1,
      0,
      1.910745,
      NULL,
      1,
      0.446492,
      1.414404,
      1,
      NULL,
      0.477682,
      NULL,
      0.511845,
      NULL,
      1.246634,
      1.321261,
      0.023447,
      NULL,
      1,
      NULL,
      1,
      0.785825,
      6,
      1,
      6,
      0.302893,
      7.862341,
      NULL,
      3.921761,
      NULL,
      2.285651,
      0,
      NULL,
      0.381502,
      5.978490,
      4,
      4.065701,
      4.639223,
      4,
      NULL,
      3.707257,
      NULL,
      6.460009,
      4.852730,
      6,
      0.222022,
      NULL,
      0.313339,
      NULL,
      0.261304,
      0.058187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1,
      0.529396,
      0.123314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      3.163384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7,
      NULL,
      2.148614,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.507745,
      8.383582,
      1.452021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      0.744538,
      0,
      NULL,
      3.088900,
      3,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.667063,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.507409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '00040',
      '',
      0,
      NULL,
      '',
      '',
      0,
      '1101',
      '',
      '',
      5.080057,
      7,
      NULL,
      3.385331,
      1.103539,
      NULL,
      3.182527,
      1,
      2);
commit;
end;
/


