set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4231',
      '12101340',
      33.253837,
      53,
      '3230032',
      162,
      NULL,
      NULL,
      NULL,
      '443010',
      4,
      NULL,
      NULL,
      61.104239,
      0,
      NULL,
      0,
      1.188804,
      2.497991,
      NULL,
      1,
      0,
      0.224934,
      0,
      NULL,
      1,
      NULL,
      0.974523,
      0.593705,
      1,
      0,
      NULL,
      3,
      1,
      1.874038,
      1.214434,
      0.031081,
      1.329122,
      0,
      1,
      NULL,
      3.423506,
      0,
      0,
      NULL,
      NULL,
      1.128300,
      NULL,
      NULL,
      2,
      7,
      NULL,
      3.649937,
      0.836985,
      0,
      2,
      1.293863,
      NULL,
      1,
      0,
      1.701667,
      0.883531,
      2,
      NULL,
      3,
      0,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      0.457428,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      0.087332,
      0,
      0.903449,
      0.079382,
      0,
      0,
      0.484778,
      NULL,
      1,
      0,
      1.516593,
      1,
      1.211274,
      NULL,
      1,
      1.929558,
      0,
      NULL,
      1,
      0,
      0,
      1.671566,
      NULL,
      NULL,
      NULL,
      NULL,
      0.682183,
      1.914896,
      2.315713,
      0,
      3.604677,
      1.606658,
      7.075646,
      NULL,
      2.104576,
      5,
      NULL,
      3.869326,
      3.017838,
      4.650963,
      NULL,
      2.498849,
      1,
      0.099715,
      1.580645,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.301419,
      0.847093,
      NULL,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      4.434661,
      1,
      3.368365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      2.013525,
      0.168806,
      5.980712,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.718949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.197480,
      0.718026,
      NULL,
      1.124837,
      NULL,
      NULL,
      0,
      3,
      1,
      1,
      1,
      NULL,
      1,
      0,
      1,
      0.084049,
      1.920432,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.964703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '33334',
      NULL,
      '',
      0.772774,
      '',
      '',
      '',
      1.985352,
      '1001',
      '',
      '',
      5.349450,
      1,
      3.432241,
      2,
      1.994816,
      1.892173,
      NULL,
      0,
      2.612237);
commit;
end;
/


