set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1433',
      '01231412',
      7,
      NULL,
      '3021314',
      NULL,
      5,
      3,
      1,
      '403123',
      4.035655,
      ' 4-10-1996',
      51.549016,
      35,
      1.797866,
      NULL,
      3.883557,
      0.506311,
      2.970252,
      NULL,
      1,
      1.015478,
      0,
      0.407565,
      0.738582,
      1,
      3.740192,
      1.522093,
      1.967757,
      3,
      0.039289,
      0.893868,
      6.887402,
      1.067446,
      1,
      0,
      0.648428,
      1.468452,
      NULL,
      1,
      4.431643,
      0.411839,
      NULL,
      1.879105,
      NULL,
      NULL,
      0.920220,
      1,
      3.000401,
      10.421351,
      2.757442,
      5.553063,
      3,
      NULL,
      0.562967,
      1,
      0,
      2.163483,
      1.049489,
      1.219397,
      0.117704,
      NULL,
      NULL,
      1,
      3,
      1,
      0.520720,
      1.592222,
      1,
      NULL,
      0,
      7.967189,
      0,
      NULL,
      NULL,
      1.262655,
      NULL,
      NULL,
      0.209391,
      2,
      0,
      1.463002,
      1,
      3,
      NULL,
      5,
      1.430792,
      NULL,
      1,
      1.601868,
      0,
      1.128473,
      0.838219,
      0.580559,
      1.954777,
      1,
      0,
      0.534659,
      1,
      0,
      NULL,
      0,
      1.515567,
      0,
      0.395641,
      0,
      1,
      0.264013,
      0,
      NULL,
      NULL,
      0.572421,
      0,
      0,
      0.254537,
      1,
      1.581513,
      1,
      4.073389,
      5,
      2,
      NULL,
      1.958049,
      4,
      6.266672,
      8,
      0.991315,
      10,
      0,
      3.194134,
      1.357258,
      0,
      0.783706,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.496217,
      2,
      NULL,
      NULL,
      1.485276,
      3.392980,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.889628,
      NULL,
      9,
      2,
      2.513698,
      9,
      1.013835,
      1.220689,
      2.646795,
      2,
      2.827503,
      NULL,
      1.162925,
      2,
      1.762875,
      2,
      1,
      5.003061,
      1.653264,
      2.371264,
      0,
      1.307227,
      2,
      0.326946,
      NULL,
      NULL,
      NULL,
      0.722018,
      11.970465,
      0.005657,
      2.922439,
      2,
      0,
      3,
      NULL,
      1,
      NULL,
      2.066773,
      3.479530,
      0.433400,
      2.900393,
      1.818764,
      2.106183,
      NULL,
      0,
      NULL,
      2.369317,
      NULL,
      0.836829,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      0.723760,
      0.655595,
      1.036437,
      1.147949,
      2,
      2,
      2.325289,
      1.312568,
      0.576179,
      NULL,
      3.829440,
      1.520351,
      0,
      1,
      1,
      0,
      NULL,
      1,
      1,
      0.505387,
      1.721695,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.709169,
      NULL,
      '30440',
      '',
      0.188619,
      '',
      NULL,
      '',
      2,
      '3120',
      '',
      '',
      3,
      NULL,
      2.404784,
      2,
      1,
      3.436410,
      3,
      3,
      0);
commit;
end;
/


